/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SplashScreen
extends JFrame {
    private SplashScreenProgressRenderer progressRenderer;
    private SwingRenderingProgressMonitor progressMonitor;

    public SplashScreen() {
        this.setUndecorated(true);
        JPanel contentPane = (JPanel)this.getContentPane();
        EtchedBorder margin = new EtchedBorder(1, Color.white, Color.gray);
        contentPane.setBorder(margin);
        JPanel innerContentPane = new JPanel();
        innerContentPane.setBorder(new EmptyBorder(10, 10, 2, 10));
        contentPane.add(innerContentPane);
        innerContentPane.setLayout(new GridBagLayout());
        JLabel logo = new JLabel(ImageProvider.get("logo.png"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 2;
        innerContentPane.add((Component)logo, gbc);
        JLabel caption = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor"));
        caption.setFont(new Font("Helvetica", 1, 20));
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.insets = new Insets(30, 0, 0, 0);
        innerContentPane.add((Component)caption, gbc);
        JLabel version = new JLabel(I18n.tr("Version {0}", Version.getInstance().getVersionString()));
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        innerContentPane.add((Component)version, gbc);
        JSeparator separator = new JSeparator(0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 0, 5, 0);
        innerContentPane.add((Component)separator, gbc);
        this.progressRenderer = new SplashScreenProgressRenderer();
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 10, 5);
        innerContentPane.add((Component)this.progressRenderer, gbc);
        this.progressMonitor = new SwingRenderingProgressMonitor(this.progressRenderer);
        this.pack();
        this.setLocationRelativeTo(null);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                SplashScreen.this.setVisible(false);
            }
        });
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private static class SplashScreenProgressRenderer
    extends JPanel
    implements ProgressRenderer {
        private JLabel lblTaskTitle;
        private JLabel lblCustomText;
        private JProgressBar progressBar;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(5, 0, 0, 5);
            this.lblTaskTitle = new JLabel("");
            this.add((Component)this.lblTaskTitle, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(5, 0, 0, 5);
            this.lblCustomText = new JLabel("");
            this.add((Component)this.lblCustomText, gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(5, 0, 0, 5);
            this.progressBar = new JProgressBar(0);
            this.add((Component)this.progressBar, gc);
        }

        public SplashScreenProgressRenderer() {
            this.build();
        }

        public void setCustomText(String message) {
            this.lblCustomText.setText(message);
            this.repaint();
        }

        public void setIndeterminate(boolean indeterminate) {
            this.progressBar.setIndeterminate(indeterminate);
            this.repaint();
        }

        public void setMaximum(int maximum) {
            this.progressBar.setMaximum(maximum);
            this.repaint();
        }

        public void setTaskTitle(String taskTitle) {
            this.lblTaskTitle.setText(taskTitle);
            this.repaint();
        }

        public void setValue(int value) {
            this.progressBar.setValue(value);
            this.repaint();
        }
    }
}

