/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.SimpleNodeElemStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPaintVisitor
implements PaintVisitor {
    private Graphics2D g;
    private NavigatableComponent nc;
    private boolean zoomLevelDisplay;
    private boolean drawMultipolygon;
    private boolean drawRestriction;
    private boolean leftHandTraffic;
    private ElemStyles.StyleSet styles;
    private double circum;
    private double dist;
    private static int paintid = 0;
    private EastNorth minEN;
    private EastNorth maxEN;
    private MapPainter painter;
    private MapPaintSettings paintSettings;
    private boolean inactive;
    DataSet data;

    protected boolean isZoomOk(ElemStyle e) {
        if (!this.zoomLevelDisplay) {
            return true;
        }
        if (e == null) {
            return this.circum < 1500.0;
        }
        return !(this.circum >= (double)e.maxScale) && !(this.circum < (double)e.minScale);
    }

    public ElemStyle getPrimitiveStyle(OsmPrimitive osm, boolean nodefault) {
        if (osm.mappaintStyle == null) {
            if (this.styles != null) {
                osm.mappaintStyle = this.styles.get(osm);
                if (osm instanceof Way) {
                    ((Way)osm).isMappaintArea = this.styles.isArea(osm);
                }
            }
            if (osm.mappaintStyle == null) {
                if (osm instanceof Node) {
                    osm.mappaintStyle = SimpleNodeElemStyle.INSTANCE;
                } else if (osm instanceof Way) {
                    osm.mappaintStyle = LineElemStyle.UNTAGGED_WAY;
                }
            }
        }
        if (nodefault && osm.mappaintStyle == LineElemStyle.UNTAGGED_WAY) {
            return null;
        }
        return osm.mappaintStyle;
    }

    public IconElemStyle getPrimitiveNodeStyle(OsmPrimitive osm) {
        if (osm.mappaintStyle == null && this.styles != null) {
            osm.mappaintStyle = this.styles.getIcon(osm);
        }
        return (IconElemStyle)osm.mappaintStyle;
    }

    public boolean isPrimitiveArea(Way osm) {
        if (osm.mappaintStyle == null && this.styles != null) {
            osm.mappaintStyle = this.styles.get(osm);
            osm.isMappaintArea = this.styles.isArea(osm);
        }
        return osm.isMappaintArea;
    }

    public void drawNode(Node n) {
        if (n.getEastNorth().east() > this.maxEN.east() || n.getEastNorth().north() > this.maxEN.north() || n.getEastNorth().east() < this.minEN.east() || n.getEastNorth().north() < this.minEN.north()) {
            return;
        }
        ElemStyle nodeStyle = this.getPrimitiveStyle(n, false);
        if (this.isZoomOk(nodeStyle)) {
            nodeStyle.paintPrimitive(n, this.paintSettings, this.painter, this.data.isSelected(n), false);
        }
    }

    public void drawWay(Way w, int fillAreas) {
        if (w.getNodesCount() < 2) {
            return;
        }
        if (w.hasIncompleteNodes()) {
            return;
        }
        double minx = 10000.0;
        double maxx = -10000.0;
        double miny = 10000.0;
        double maxy = -10000.0;
        for (Node n : w.getNodes()) {
            if (n.getEastNorth().east() > maxx) {
                maxx = n.getEastNorth().east();
            }
            if (n.getEastNorth().north() > maxy) {
                maxy = n.getEastNorth().north();
            }
            if (n.getEastNorth().east() < minx) {
                minx = n.getEastNorth().east();
            }
            if (!(n.getEastNorth().north() < miny)) continue;
            miny = n.getEastNorth().north();
        }
        if (minx > this.maxEN.east() || miny > this.maxEN.north() || maxx < this.minEN.east() || maxy < this.minEN.north()) {
            return;
        }
        ElemStyle wayStyle = this.getPrimitiveStyle(w, false);
        if (!this.isZoomOk(wayStyle)) {
            return;
        }
        if (wayStyle instanceof LineElemStyle) {
            wayStyle.paintPrimitive(w, this.paintSettings, this.painter, this.data.isSelected(w), false);
        } else if (wayStyle instanceof AreaElemStyle) {
            AreaElemStyle areaStyle = (AreaElemStyle)wayStyle;
            if ((double)fillAreas > this.dist) {
                this.painter.drawArea(this.getPolygon(w), this.data.isSelected(w) ? this.paintSettings.getSelectedColor() : areaStyle.color, this.painter.getAreaName(w));
            }
            areaStyle.getLineStyle().paintPrimitive(w, this.paintSettings, this.painter, this.data.isSelected(w), false);
        }
    }

    public void paintUnselectedRelation(Relation r) {
        if (this.drawMultipolygon && "multipolygon".equals(r.get("type"))) {
            this.drawMultipolygon(r);
        } else if (this.drawRestriction && "restriction".equals(r.get("type"))) {
            this.drawRestriction(r);
        }
    }

    public void drawRestriction(Relation r) {
        IconElemStyle nodeStyle;
        Node viaNode;
        Way fromWay = null;
        Way toWay = null;
        OsmPrimitive via = null;
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete()) {
                return;
            }
            if (m.isWay()) {
                Way w = m.getWay();
                if (w.getNodesCount() < 2) continue;
                if ("from".equals(m.getRole())) {
                    if (fromWay != null) continue;
                    fromWay = w;
                    continue;
                }
                if ("to".equals(m.getRole())) {
                    if (toWay != null) continue;
                    toWay = w;
                    continue;
                }
                if (!"via".equals(m.getRole()) || via != null) continue;
                via = w;
                continue;
            }
            if (!m.isNode()) continue;
            Node n = m.getNode();
            if (!"via".equals(m.getRole()) || via != null) continue;
            via = n;
        }
        if (fromWay == null || toWay == null || via == null) {
            return;
        }
        if (via instanceof Node) {
            viaNode = via;
            if (!fromWay.isFirstLastNode(viaNode)) {
                return;
            }
        } else {
            Way viaWay = (Way)via;
            Node firstNode = viaWay.firstNode();
            Node lastNode = viaWay.lastNode();
            Boolean onewayvia = false;
            String onewayviastr = viaWay.get("oneway");
            if (onewayviastr != null) {
                if ("-1".equals(onewayviastr)) {
                    onewayvia = true;
                    Node tmp = firstNode;
                    firstNode = lastNode;
                    lastNode = tmp;
                } else {
                    onewayvia = OsmUtils.getOsmBoolean(onewayviastr);
                    if (onewayvia == null) {
                        onewayvia = false;
                    }
                }
            }
            if (fromWay.isFirstLastNode(firstNode)) {
                viaNode = firstNode;
            } else if (!onewayvia.booleanValue() && fromWay.isFirstLastNode(lastNode)) {
                viaNode = lastNode;
            } else {
                return;
            }
        }
        Node fromNode = null;
        fromNode = fromWay.firstNode() == via ? fromWay.getNode(1) : fromWay.getNode(fromWay.getNodesCount() - 2);
        Point pFrom = this.nc.getPoint(fromNode);
        Point pVia = this.nc.getPoint(viaNode);
        double distanceFromVia = 14.0;
        double dx = pFrom.x >= pVia.x ? (double)(pFrom.x - pVia.x) : (double)(pVia.x - pFrom.x);
        double dy = pFrom.y >= pVia.y ? (double)(pFrom.y - pVia.y) : (double)(pVia.y - pFrom.y);
        double fromAngle = dx == 0.0 ? 1.5707963267948966 : Math.atan(dy / dx);
        double fromAngleDeg = Math.toDegrees(fromAngle);
        double vx = distanceFromVia * Math.cos(fromAngle);
        double vy = distanceFromVia * Math.sin(fromAngle);
        if (pFrom.x < pVia.x) {
            vx = -vx;
        }
        if (pFrom.y < pVia.y) {
            vy = -vy;
        }
        double distanceFromWay = 10.0;
        double vx2 = 0.0;
        double vy2 = 0.0;
        double iconAngle = 0.0;
        if (pFrom.x >= pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg - 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 90.0));
            }
            iconAngle = 270.0 + fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg));
            } else {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 180.0));
            }
            iconAngle = 90.0 - fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg - 90.0));
            }
            iconAngle = 90.0 + fromAngleDeg;
        }
        if (pFrom.x >= pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 180.0));
            } else {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg));
            }
            iconAngle = 270.0 - fromAngleDeg;
        }
        if ((nodeStyle = this.getPrimitiveNodeStyle(r)) == null) {
            return;
        }
        this.painter.drawRestriction(this.inactive || r.isDisabled() ? nodeStyle.getDisabledIcon() : nodeStyle.icon, pVia, vx, vx2, vy, vy2, iconAngle, this.data.isSelected(r));
    }

    public boolean drawMultipolygon(Relation r) {
        boolean drawn = false;
        Multipolygon multipolygon = new Multipolygon(this.nc);
        multipolygon.load(r);
        ElemStyle wayStyle = this.getPrimitiveStyle(r, false);
        boolean disabled = r.isDisabled();
        if (this.styles != null && !(wayStyle instanceof AreaElemStyle)) {
            for (Way w : multipolygon.getOuterWays()) {
                wayStyle = this.styles.getArea(w);
                boolean bl = disabled = disabled || w.isDisabled();
                if (wayStyle == null) continue;
                break;
            }
        }
        if (wayStyle instanceof AreaElemStyle) {
            boolean zoomok = this.isZoomOk(wayStyle);
            boolean visible = false;
            drawn = true;
            if (zoomok && !disabled && !multipolygon.getOuterWays().isEmpty()) {
                AreaElemStyle areaStyle = (AreaElemStyle)wayStyle;
                for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                    Polygon p = pd.get();
                    if (!this.isPolygonVisible(p)) continue;
                    boolean selected = pd.selected || this.data.isSelected(r);
                    this.painter.drawArea(p, selected ? this.paintSettings.getRelationSelectedColor() : areaStyle.color, this.painter.getAreaName(r));
                    visible = true;
                }
            }
            if (!visible) {
                return drawn;
            }
            for (Way wInner : multipolygon.getInnerWays()) {
                ElemStyle innerStyle = this.getPrimitiveStyle(wInner, true);
                if (innerStyle == null) {
                    if (this.data.isSelected(wInner) || disabled) continue;
                    if (zoomok && (wInner.mappaintDrawnCode != paintid || multipolygon.getOuterWays().isEmpty())) {
                        ((AreaElemStyle)wayStyle).getLineStyle().paintPrimitive(wInner, this.paintSettings, this.painter, this.data.isSelected(wInner) || this.data.isSelected(r), false);
                    }
                    wInner.mappaintDrawnCode = paintid;
                    continue;
                }
                if (!wayStyle.equals(innerStyle)) continue;
                wInner.mappaintDrawnAreaCode = paintid;
                if (this.data.isSelected(wInner)) continue;
                wInner.mappaintDrawnCode = paintid;
                this.drawWay(wInner, 0);
            }
            for (Way wOuter : multipolygon.getOuterWays()) {
                ElemStyle outerStyle = this.getPrimitiveStyle(wOuter, true);
                if (outerStyle == null) {
                    if (this.data.isSelected(wOuter)) continue;
                    if (zoomok) {
                        ((AreaElemStyle)wayStyle).getLineStyle().paintPrimitive(wOuter, this.paintSettings, this.painter, this.data.isSelected(wOuter) || this.data.isSelected(r), r.isSelected());
                    }
                    wOuter.mappaintDrawnCode = paintid;
                    continue;
                }
                if (!(outerStyle instanceof AreaElemStyle)) continue;
                wOuter.mappaintDrawnAreaCode = paintid;
                if (this.data.isSelected(wOuter)) continue;
                wOuter.mappaintDrawnCode = paintid;
                this.drawWay(wOuter, 0);
            }
        }
        return drawn;
    }

    protected boolean isPolygonVisible(Polygon polygon) {
        Rectangle bounds = polygon.getBounds();
        if (bounds.width == 0 && bounds.height == 0) {
            return false;
        }
        if (bounds.x > this.nc.getWidth()) {
            return false;
        }
        if (bounds.y > this.nc.getHeight()) {
            return false;
        }
        if (bounds.x + bounds.width < 0) {
            return false;
        }
        return bounds.y + bounds.height >= 0;
    }

    protected Polygon getPolygon(Way w) {
        Polygon polygon = new Polygon();
        for (Node n : w.getNodes()) {
            Point p = this.nc.getPoint(n);
            polygon.addPoint(p.x, p.y);
        }
        return polygon;
    }

    protected Point2D getCentroid(Polygon p) {
        double cx = 0.0;
        double cy = 0.0;
        double a = 0.0;
        for (int i = 0; i < p.npoints; ++i) {
            int j = i + 1 == p.npoints ? 0 : i + 1;
            a += (double)(p.xpoints[i] * p.ypoints[j] - p.ypoints[i] * p.xpoints[j]);
            cx += (double)((p.xpoints[i] + p.xpoints[j]) * (p.xpoints[i] * p.ypoints[j] - p.ypoints[i] * p.xpoints[j]));
            cy += (double)((p.ypoints[i] + p.ypoints[j]) * (p.xpoints[i] * p.ypoints[j] - p.ypoints[i] * p.xpoints[j]));
        }
        return new Point2D.Double(cx / (3.0 * a), cy / (3.0 * a));
    }

    protected double getArea(Polygon p) {
        double sum = 0.0;
        for (int i = 0; i < p.npoints; ++i) {
            int j = i + 1 == p.npoints ? 0 : i + 1;
            sum = sum + (double)(p.xpoints[i] * p.ypoints[j]) - (double)(p.ypoints[i] * p.xpoints[j]);
        }
        return Math.abs(sum / 2.0);
    }

    <T extends OsmPrimitive> Collection<T> selectedLast(final DataSet data, Collection<T> prims) {
        ArrayList<T> sorted = new ArrayList<T>(prims);
        Collections.sort(sorted, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                boolean s1 = data.isSelected((OsmPrimitive)o1);
                boolean s2 = data.isSelected((OsmPrimitive)o2);
                if (s1 && !s2) {
                    return 1;
                }
                if (!s1 && s2) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        });
        return sorted;
    }

    @Override
    public void visitAll(DataSet data, boolean virtual, Bounds bounds) {
        BBox bbox = new BBox(bounds);
        this.data = data;
        ++paintid;
        int fillAreas = Main.pref.getInteger("mappaint.fillareas", 10000000);
        LatLon ll1 = this.nc.getLatLon(0, 0);
        LatLon ll2 = this.nc.getLatLon(100, 0);
        this.dist = ll1.greatCircleDistance(ll2);
        this.zoomLevelDisplay = Main.pref.getBoolean("mappaint.zoomLevelDisplay", false);
        this.circum = this.nc.getDist100Pixel();
        this.styles = MapPaintStyles.getStyles().getStyleSet();
        this.drawMultipolygon = Main.pref.getBoolean("mappaint.multipolygon", true);
        this.drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);
        this.leftHandTraffic = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.minEN = this.nc.getEastNorth(0, this.nc.getHeight() - 1);
        this.maxEN = this.nc.getEastNorth(this.nc.getWidth() - 1, 0);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.painter = new MapPainter(this.paintSettings, this.g, this.inactive, this.nc, virtual, this.dist, this.circum);
        if ((double)fillAreas > this.dist && this.styles != null && this.styles.hasAreas()) {
            LinkedList<Way> noAreaWays = new LinkedList<Way>();
            List<Way> list = data.searchWays(bbox);
            for (Way way : list) {
                if (!way.isDisabled() || !way.isDrawable() || way.mappaintDrawnCode == paintid) continue;
                this.drawWay(way, 0);
                way.mappaintDrawnCode = paintid;
            }
            for (Relation relation : data.searchRelations(bbox)) {
                if (!relation.isDrawable()) continue;
                this.paintUnselectedRelation(relation);
            }
            for (Way way : this.selectedLast(data, list)) {
                if (!way.isDrawable() || way.mappaintDrawnCode == paintid) continue;
                if (this.isPrimitiveArea(way)) {
                    if (way.mappaintDrawnAreaCode == paintid) continue;
                    this.drawWay(way, fillAreas);
                    continue;
                }
                if (data.isSelected(way)) continue;
                noAreaWays.add(way);
            }
            for (Way way : noAreaWays) {
                this.drawWay(way, 0);
                way.mappaintDrawnCode = paintid;
            }
        } else {
            this.drawMultipolygon = false;
            List<Way> ways = data.searchWays(bbox);
            for (Way way : ways) {
                if (!way.isDisabled() || !way.isDrawable() || data.isSelected(way)) continue;
                this.drawWay(way, 0);
                way.mappaintDrawnCode = paintid;
            }
            for (Relation osm : data.searchRelations(bbox)) {
                if (!osm.isDrawable()) continue;
                this.paintUnselectedRelation(osm);
            }
            for (Way way : ways) {
                if (!way.isDrawable() || data.isSelected(way)) continue;
                this.drawWay(way, 0);
            }
        }
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (!osmPrimitive.isUsable() || osmPrimitive instanceof Node || !(osmPrimitive instanceof Relation) && osmPrimitive.mappaintDrawnCode == paintid) continue;
            osmPrimitive.visit(new AbstractVisitor(){

                public void visit(Way w) {
                    MapPaintVisitor.this.drawWay(w, 0);
                }

                public void visit(Node n) {
                }

                public void visit(Relation r) {
                    for (RelationMember m : r.getMembers()) {
                        OsmPrimitive osm = m.getMember();
                        if (!osm.isDrawable()) continue;
                        ElemStyle style = MapPaintVisitor.this.getPrimitiveStyle(m.getMember(), false);
                        if (osm instanceof Way) {
                            if (style instanceof AreaElemStyle) {
                                ((AreaElemStyle)style).getLineStyle().paintPrimitive(osm, MapPaintVisitor.this.paintSettings, MapPaintVisitor.this.painter, true, true);
                            } else {
                                style.paintPrimitive(osm, MapPaintVisitor.this.paintSettings, MapPaintVisitor.this.painter, true, true);
                            }
                        } else if (osm instanceof Node && MapPaintVisitor.this.isZoomOk(style)) {
                            style.paintPrimitive(osm, MapPaintVisitor.this.paintSettings, MapPaintVisitor.this.painter, true, true);
                        }
                        osm.mappaintDrawnCode = paintid;
                    }
                }
            });
        }
        for (Node node : data.searchNodes(bbox)) {
            if (node.isIncomplete() || node.isDeleted() || !data.isSelected(node) && node.isDisabledAndHidden() || node.mappaintDrawnCode == paintid) continue;
            this.drawNode(node);
        }
        this.painter.drawVirtualNodes(data.searchWays(bbox));
    }

    @Override
    public void setGraphics(Graphics2D g) {
        this.g = g;
    }

    @Override
    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    @Override
    public void setNavigatableComponent(NavigatableComponent nc) {
        this.nc = nc;
    }
}

