/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChangesetCacheEvent
implements ChangesetCacheEvent {
    private final Set<Changeset> added;
    private final Set<Changeset> modified;
    private final Set<Changeset> removed;
    private final ChangesetCache source;

    public DefaultChangesetCacheEvent(ChangesetCache source) {
        this.source = source;
        this.added = new HashSet<Changeset>();
        this.modified = new HashSet<Changeset>();
        this.removed = new HashSet<Changeset>();
    }

    @Override
    public Collection<Changeset> getAddedChangesets() {
        return Collections.unmodifiableCollection(this.added);
    }

    @Override
    public Collection<Changeset> getRemovedChangesets() {
        return Collections.unmodifiableCollection(this.removed);
    }

    @Override
    public ChangesetCache getSource() {
        return this.source;
    }

    @Override
    public Collection<Changeset> getUpdatedChangesets() {
        return Collections.unmodifiableCollection(this.modified);
    }

    public void rememberAddedChangeset(Changeset cs) {
        if (cs == null) {
            return;
        }
        this.added.add(cs);
    }

    public void rememberUpdatedChangeset(Changeset cs) {
        if (cs == null) {
            return;
        }
        this.modified.add(cs);
    }

    public void rememberRemovedChangeset(Changeset cs) {
        if (cs == null) {
            return;
        }
        this.removed.add(cs);
    }

    public boolean isEmpty() {
        return this.added.isEmpty() && this.modified.isEmpty() && this.removed.isEmpty();
    }
}

