/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCommand
extends Command {
    private final OsmPrimitive osm;
    private final OsmPrimitive newOsm;

    public ChangeCommand(OsmPrimitive osm, OsmPrimitive newOsm) {
        this.osm = osm;
        this.newOsm = newOsm;
    }

    public ChangeCommand(OsmDataLayer layer, OsmPrimitive osm, OsmPrimitive newOsm) {
        super(layer);
        this.osm = osm;
        this.newOsm = newOsm;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.osm.cloneFrom(this.newOsm);
        this.osm.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.osm);
    }

    @Override
    public JLabel getDescription() {
        String msg = "";
        switch (OsmPrimitiveType.from(this.osm)) {
            case NODE: {
                msg = I18n.marktr("Change node {0}");
                break;
            }
            case WAY: {
                msg = I18n.marktr("Change way {0}");
                break;
            }
            case RELATION: {
                msg = I18n.marktr("Change relation {0}");
            }
        }
        return new JLabel(I18n.tr(msg, this.osm.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get(OsmPrimitiveType.from(this.osm)), 0);
    }
}

