/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostDownloadHandler
implements Runnable {
    private DownloadTask task;
    private List<Future<?>> futures;

    public PostDownloadHandler(DownloadTask task, Future<?> future) {
        this.task = task;
        this.futures = new ArrayList();
        if (future != null) {
            this.futures.add(future);
        }
    }

    public PostDownloadHandler(DownloadTask task, Future<?> ... futures) {
        this.task = task;
        this.futures = new ArrayList();
        if (futures == null) {
            return;
        }
        for (Future<?> future : futures) {
            this.futures.add(future);
        }
    }

    public PostDownloadHandler(DownloadTask task, List<Future<?>> futures) {
        this.task = task;
        this.futures = new ArrayList();
        if (futures == null) {
            return;
        }
        this.futures.addAll(futures);
    }

    @Override
    public void run() {
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        LinkedHashSet<Object> errors = new LinkedHashSet<Object>();
        errors.addAll(this.task.getErrorObjects());
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            Object error = errors.iterator().next();
            if (error instanceof Exception) {
                ExceptionDialogUtil.explainException((Exception)error);
                return;
            }
            JOptionPane.showMessageDialog(Main.parent, error.toString(), I18n.tr("Error during download"), 0);
            return;
        }
        if (!errors.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Object e : errors) {
                if (e instanceof String) {
                    sb.append("<li>").append(e).append("</li>").append("<br>");
                    continue;
                }
                if (!(e instanceof Exception)) continue;
                sb.append("<li>").append(ExceptionUtil.explainException((Exception)e)).append("</li>").append("<br>");
            }
            sb.insert(0, "<html><ul>");
            sb.append("</ul></html>");
            JOptionPane.showMessageDialog(Main.parent, sb.toString(), I18n.tr("Errors during download"), 0);
            return;
        }
    }
}

