/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSelectionAction
extends JosmAction {
    public void handlePrimitiveGoneException(long id, OsmPrimitiveType type) {
        MultiFetchServerObjectReader reader = new MultiFetchServerObjectReader();
        reader.append(this.getCurrentDataSet(), id, type);
        try {
            DataSet ds = reader.parseOsm(NullProgressMonitor.INSTANCE);
            Main.map.mapView.getEditLayer().mergeFrom(ds);
        }
        catch (Exception e) {
            ExceptionDialogUtil.explainException(e);
        }
    }

    public void updatePrimitives(Collection<OsmPrimitive> selection) {
        UpdatePrimitivesTask task = new UpdatePrimitivesTask(Main.main.getEditLayer(), selection);
        Main.worker.submit(task);
    }

    public void updatePrimitive(PrimitiveId id) throws IllegalStateException, IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(id, "id");
        if (this.getEditLayer() == null) {
            throw new IllegalStateException(I18n.tr("No current dataset found"));
        }
        OsmPrimitive primitive = this.getEditLayer().data.getPrimitiveById(id);
        if (primitive == null) {
            throw new IllegalStateException(I18n.tr("Did not find an object with id {0} in the current dataset", id));
        }
        this.updatePrimitives(Collections.singleton(primitive));
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update selection"), "updateselection", I18n.tr("Updates the currently selected objects from the server (re-downloads data)"), Shortcut.registerShortcut("file:updateselection", I18n.tr("Update selection"), 85, 15), true);
        this.putValue("help", HelpUtil.ht("/Action/UpdateSelection"));
    }

    public UpdateSelectionAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register) {
        super(name, iconName, tooltip, shortcut, register);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> toUpdate = this.getData();
        if (toUpdate.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no selected objects to update."), I18n.tr("Selection empty"), 1);
            return;
        }
        this.updatePrimitives(toUpdate);
    }

    public Collection<OsmPrimitive> getData() {
        return this.getCurrentDataSet().getSelected();
    }
}

