/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DuplicateLayerAction
extends JosmAction {
    public DuplicateLayerAction() {
        super(I18n.tr("Duplicate Layer"), "dialogs/duplicatelayer", I18n.tr("Make a duplicate of the currently selected layer."), Shortcut.registerShortcut("layer:duplicate", I18n.tr("Layer: {0}", I18n.tr("Duplicate")), 78, 0), true);
        this.putValue("help", HelpUtil.ht("/Action/DuplicateLayer"));
    }

    public void actionPerformed(ActionEvent e) {
        OsmDataLayer sourceLayer = Main.main.getEditLayer();
        if (sourceLayer == null) {
            return;
        }
        this.duplicate(sourceLayer);
    }

    public void duplicate(Layer layer) {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        ArrayList<String> layerNames = new ArrayList<String>();
        for (Layer l : Main.map.mapView.getAllLayers()) {
            layerNames.add(l.getName());
        }
        if (layer instanceof OsmDataLayer) {
            OsmDataLayer oldLayer = (OsmDataLayer)layer;
            String newName = I18n.tr("Copy of {0}", oldLayer.getName());
            int i = 2;
            while (layerNames.contains(newName)) {
                newName = I18n.tr("Copy {1} of {0}", oldLayer.getName(), i);
                ++i;
            }
            Main.main.addLayer(new OsmDataLayer(oldLayer.data.clone(), newName, null));
        }
    }

    public static boolean canDuplicate(Layer layer) {
        return layer instanceof OsmDataLayer;
    }
}

