/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import java.io.File;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.DebugEvent;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.cdbg.basic.x86.X86CFrame;
import sun.jvm.hotspot.debugger.win32.Win32Debugger;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;
import sun.jvm.hotspot.utilities.AddressOps;

class Win32CDebugger
implements CDebugger,
ProcessControl {
    private Win32Debugger dbg;

    Win32CDebugger(Win32Debugger dbg) {
        this.dbg = dbg;
    }

    @Override
    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    @Override
    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    @Override
    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        for (LoadObject obj : objs) {
            if (!AddressOps.lte(obj.getBase(), pc) || pc.minus(obj.getBase()) >= obj.getSize()) continue;
            return obj;
        }
        return null;
    }

    @Override
    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        X86ThreadContext context = (X86ThreadContext)thread.getContext();
        Address ebp = context.getRegisterAsAddress(6);
        if (ebp == null) {
            return null;
        }
        Address pc = context.getRegisterAsAddress(14);
        if (pc == null) {
            return null;
        }
        return new X86CFrame(this, ebp, pc);
    }

    @Override
    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    @Override
    public ProcessControl getProcessControl() throws DebuggerException {
        return this;
    }

    @Override
    public boolean canDemangle() {
        return false;
    }

    @Override
    public String demangle(String sym) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() throws DebuggerException {
        this.dbg.suspend();
    }

    @Override
    public void resume() throws DebuggerException {
        this.dbg.resume();
    }

    @Override
    public boolean isSuspended() throws DebuggerException {
        return this.dbg.isSuspended();
    }

    @Override
    public void setBreakpoint(Address addr) throws DebuggerException {
        this.dbg.setBreakpoint(addr);
    }

    @Override
    public void clearBreakpoint(Address addr) throws DebuggerException {
        this.dbg.clearBreakpoint(addr);
    }

    @Override
    public boolean isBreakpointSet(Address addr) throws DebuggerException {
        return this.dbg.isBreakpointSet(addr);
    }

    @Override
    public DebugEvent debugEventPoll() throws DebuggerException {
        return this.dbg.debugEventPoll();
    }

    @Override
    public void debugEventContinue() throws DebuggerException {
        this.dbg.debugEventContinue();
    }
}

