/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.Logging;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;
import sun.util.logging.PlatformLogger;

public class LogManager {
    private static LogManager manager;
    private static final Handler[] emptyHandlers;
    private Properties props = new Properties();
    private PropertyChangeSupport changes = new PropertyChangeSupport(LogManager.class);
    private static final Level defaultLevel;
    private Hashtable<String, LoggerWeakRef> namedLoggers = new Hashtable();
    private LogNode root = new LogNode(null);
    private Logger rootLogger;
    private volatile boolean readPrimordialConfiguration;
    private boolean initializedGlobalHandlers = true;
    private boolean deathImminent;
    private final ReferenceQueue<Logger> loggerRefQueue = new ReferenceQueue();
    private static final int MAX_ITERATIONS = 400;
    private Permission ourPermission = new LoggingPermission("control", null);
    private static LoggingMXBean loggingMXBean;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";

    protected LogManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static LogManager getLogManager() {
        if (manager != null) {
            manager.readPrimordialConfiguration();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPrimordialConfiguration() {
        if (!this.readPrimordialConfiguration) {
            LogManager logManager = this;
            synchronized (logManager) {
                if (!this.readPrimordialConfiguration) {
                    if (System.out == null) {
                        return;
                    }
                    this.readPrimordialConfiguration = true;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                LogManager.this.readConfiguration();
                                PlatformLogger.redirectPlatformLoggers();
                                return null;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        this.checkAccess();
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    Logger demandLogger(String string) {
        Logger logger = this.getLogger(string);
        if (logger == null) {
            Logger logger2 = new Logger(string, null);
            do {
                if (!this.addLogger(logger2)) continue;
                return logger2;
            } while ((logger = this.getLogger(string)) == null);
        }
        return logger;
    }

    private void processParentHandlers(Logger logger, String string) {
        int n;
        int n2 = 1;
        while ((n = string.indexOf(".", n2)) >= 0) {
            String string2 = string.substring(0, n);
            if (this.getProperty(string2 + ".level") != null || this.getProperty(string2 + ".handlers") != null) {
                this.demandLogger(string2);
            }
            n2 = n + 1;
        }
    }

    private void loadLoggerHandlers(final Logger logger, final String string, final String string2) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean bl;
                if (logger != LogManager.this.rootLogger && !(bl = LogManager.this.getBooleanProperty(string + ".useParentHandlers", true))) {
                    logger.setUseParentHandlers(false);
                }
                String[] stringArray = LogManager.this.parseClassNames(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    try {
                        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string3);
                        Handler handler = (Handler)clazz.newInstance();
                        try {
                            String string22 = LogManager.this.getProperty(string3 + ".level");
                            if (string22 != null) {
                                handler.setLevel(Level.parse(string22));
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Can't set level for " + string3);
                        }
                        logger.addHandler(handler);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("Can't load log handler \"" + string3 + "\"");
                        System.err.println("" + exception);
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    final synchronized void drainLoggerRefQueueBounded() {
        LoggerWeakRef loggerWeakRef;
        for (int i = 0; i < 400 && this.loggerRefQueue != null && (loggerWeakRef = (LoggerWeakRef)this.loggerRefQueue.poll()) != null; ++i) {
            loggerWeakRef.dispose();
        }
    }

    public synchronized boolean addLogger(Logger logger) {
        LoggerWeakRef loggerWeakRef;
        String string = logger.getName();
        if (string == null) {
            throw new NullPointerException();
        }
        this.drainLoggerRefQueueBounded();
        LoggerWeakRef loggerWeakRef2 = this.namedLoggers.get(string);
        if (loggerWeakRef2 != null) {
            if (loggerWeakRef2.get() == null) {
                this.namedLoggers.remove(string);
            } else {
                return false;
            }
        }
        loggerWeakRef2 = new LoggerWeakRef(logger);
        this.namedLoggers.put(string, loggerWeakRef2);
        Level level = this.getLevelProperty(string + ".level", null);
        if (level != null) {
            LogManager.doSetLevel(logger, level);
        }
        this.loadLoggerHandlers(logger, string, string + ".handlers");
        this.processParentHandlers(logger, string);
        LogNode logNode = this.findNode(string);
        logNode.loggerRef = loggerWeakRef2;
        Logger logger2 = null;
        LogNode logNode2 = logNode.parent;
        while (logNode2 != null && ((loggerWeakRef = logNode2.loggerRef) == null || (logger2 = (Logger)loggerWeakRef.get()) == null)) {
            logNode2 = logNode2.parent;
        }
        if (logger2 != null) {
            LogManager.doSetParent(logger, logger2);
        }
        logNode.walkAndSetParent(logger);
        loggerWeakRef2.setNode(logNode);
        return true;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setLevel(level);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setLevel(level);
                return null;
            }
        });
    }

    private static void doSetParent(final Logger logger, final Logger logger2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setParent(logger2);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setParent(logger2);
                return null;
            }
        });
    }

    private LogNode findNode(String string) {
        if (string == null || string.equals("")) {
            return this.root;
        }
        LogNode logNode = this.root;
        while (string.length() > 0) {
            LogNode logNode2;
            String string2;
            int n = string.indexOf(".");
            if (n > 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (logNode.children == null) {
                logNode.children = new HashMap();
            }
            if ((logNode2 = logNode.children.get(string2)) == null) {
                logNode2 = new LogNode(logNode);
                logNode.children.put(string2, logNode2);
            }
            logNode = logNode2;
        }
        return logNode;
    }

    public synchronized Logger getLogger(String string) {
        LoggerWeakRef loggerWeakRef = this.namedLoggers.get(string);
        if (loggerWeakRef == null) {
            return null;
        }
        Logger logger = (Logger)loggerWeakRef.get();
        if (logger == null) {
            this.namedLoggers.remove(string);
        }
        return logger;
    }

    public synchronized Enumeration<String> getLoggerNames() {
        return this.namedLoggers.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException, SecurityException {
        Object object;
        String string;
        this.checkAccess();
        String string2 = System.getProperty("java.util.logging.config.class");
        if (string2 != null) {
            try {
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                    clazz.newInstance();
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
                    clazz.newInstance();
                    return;
                }
            }
            catch (Exception exception) {
                System.err.println("Logging configuration class \"" + string2 + "\" failed");
                System.err.println("" + exception);
            }
        }
        if ((string = System.getProperty("java.util.logging.config.file")) == null) {
            string = System.getProperty("java.home");
            if (string == null) {
                throw new Error("Can't find java.home ??");
            }
            object = new File(string, "lib");
            object = new File((File)object, "logging.properties");
            string = ((File)object).getCanonicalPath();
        }
        object = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
        try {
            this.readConfiguration(bufferedInputStream);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        this.checkAccess();
        Object object = this;
        synchronized (object) {
            this.props = new Properties();
            this.initializedGlobalHandlers = true;
        }
        object = this.getLoggerNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            this.resetLogger(string);
        }
    }

    private void resetLogger(String string) {
        Logger logger = this.getLogger(string);
        if (logger == null) {
            return;
        }
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            logger.removeHandler(handler);
            try {
                handler.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null && string.equals("")) {
            logger.setLevel(defaultLevel);
        } else {
            logger.setLevel(null);
        }
    }

    private String[] parseClassNames(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new String[0];
        }
        string2 = string2.trim();
        int n = 0;
        Vector<String> vector = new Vector<String>();
        while (n < string2.length()) {
            int n2;
            for (n2 = n; n2 < string2.length() && !Character.isWhitespace(string2.charAt(n2)) && string2.charAt(n2) != ','; ++n2) {
            }
            String string3 = string2.substring(n, n2);
            n = n2 + 1;
            if ((string3 = string3.trim()).length() == 0) continue;
            vector.add(string3);
        }
        return vector.toArray(new String[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkAccess();
        this.reset();
        this.props.load(inputStream);
        String[] stringArray = this.parseClassNames("config");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                clazz.newInstance();
                continue;
            }
            catch (Exception exception) {
                System.err.println("Can't load config class \"" + string + "\"");
                System.err.println("" + exception);
            }
        }
        this.setLevelsOnExistingLoggers();
        this.changes.firePropertyChange(null, null, null);
        LogManager logManager = this;
        synchronized (logManager) {
            this.initializedGlobalHandlers = false;
        }
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    String getStringProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            return n;
        }
    }

    boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("0")) {
            return false;
        }
        return bl;
    }

    Level getLevelProperty(String string, Level level) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return level;
        }
        try {
            return Level.parse(string2.trim());
        }
        catch (Exception exception) {
            return level;
        }
    }

    Filter getFilterProperty(String string, Filter filter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Filter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filter;
    }

    Formatter getFormatterProperty(String string, Formatter formatter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatter;
    }

    private synchronized void initializeGlobalHandlers() {
        if (this.initializedGlobalHandlers) {
            return;
        }
        this.initializedGlobalHandlers = true;
        if (this.deathImminent) {
            return;
        }
        this.loadLoggerHandlers(this.rootLogger, null, "handlers");
    }

    public void checkAccess() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(this.ourPermission);
    }

    private synchronized void setLevelsOnExistingLoggers() {
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".level")) continue;
            int n = string.length() - 6;
            String string2 = string.substring(0, n);
            Level level = this.getLevelProperty(string, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + string);
                continue;
            }
            Logger logger = this.getLogger(string2);
            if (logger == null) continue;
            logger.setLevel(level);
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        if (loggingMXBean == null) {
            loggingMXBean = new Logging();
        }
        return loggingMXBean;
    }

    static {
        emptyHandlers = new Handler[0];
        defaultLevel = Level.INFO;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String string = null;
                try {
                    string = System.getProperty("java.util.logging.manager");
                    if (string != null) {
                        try {
                            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                            manager = (LogManager)clazz.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                            manager = (LogManager)clazz.newInstance();
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("Could not load Logmanager \"" + string + "\"");
                    exception.printStackTrace();
                }
                if (manager == null) {
                    manager = new LogManager();
                }
                LogManager logManager = manager;
                LogManager logManager2 = manager;
                logManager2.getClass();
                logManager.rootLogger = logManager2.new RootLogger();
                manager.addLogger(manager.rootLogger);
                Logger.global.setLogManager(manager);
                manager.addLogger(Logger.global);
                return null;
            }
        });
        loggingMXBean = null;
    }

    private class RootLogger
    extends Logger {
        private RootLogger() {
            super("", null);
            this.setLevel(defaultLevel);
        }

        @Override
        public void log(LogRecord logRecord) {
            LogManager.this.initializeGlobalHandlers();
            super.log(logRecord);
        }

        @Override
        public void addHandler(Handler handler) {
            LogManager.this.initializeGlobalHandlers();
            super.addHandler(handler);
        }

        @Override
        public void removeHandler(Handler handler) {
            LogManager.this.initializeGlobalHandlers();
            super.removeHandler(handler);
        }

        @Override
        public Handler[] getHandlers() {
            LogManager.this.initializeGlobalHandlers();
            return super.getHandlers();
        }
    }

    private static class LogNode {
        HashMap<String, LogNode> children;
        LoggerWeakRef loggerRef;
        LogNode parent;

        LogNode(LogNode logNode) {
            this.parent = logNode;
        }

        void walkAndSetParent(Logger logger) {
            if (this.children == null) {
                return;
            }
            for (LogNode logNode : this.children.values()) {
                Logger logger2;
                LoggerWeakRef loggerWeakRef = logNode.loggerRef;
                Logger logger3 = logger2 = loggerWeakRef == null ? null : (Logger)loggerWeakRef.get();
                if (logger2 == null) {
                    logNode.walkAndSetParent(logger);
                    continue;
                }
                LogManager.doSetParent(logger2, logger);
            }
        }
    }

    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private String name;
        private LogNode node;
        private WeakReference<Logger> parentRef;

        LoggerWeakRef(Logger logger) {
            super(logger, LogManager.this.loggerRefQueue);
            this.name = logger.getName();
        }

        void dispose() {
            if (this.node != null) {
                manager.namedLoggers.remove(this.name);
                this.name = null;
                this.node.loggerRef = null;
                this.node = null;
            }
            if (this.parentRef != null) {
                Logger logger = (Logger)this.parentRef.get();
                if (logger != null) {
                    logger.removeChildLogger(this);
                }
                this.parentRef = null;
            }
        }

        void setNode(LogNode logNode) {
            this.node = logNode;
        }

        void setParentRef(WeakReference<Logger> weakReference) {
            this.parentRef = weakReference;
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
            this.setContextClassLoader(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogManager logManager = manager;
            LogManager logManager2 = LogManager.this;
            synchronized (logManager2) {
                LogManager.this.deathImminent = true;
                LogManager.this.initializedGlobalHandlers = true;
            }
            LogManager.this.reset();
        }
    }
}

