/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;

public class GroovyNestedConditionalInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNestedConditionalInspection.getGroupDisplayName must not return null");
        }
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Nested conditional expression" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNestedConditionalInspection.getDisplayName must not return null");
        }
        return "Nested conditional expression";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Nested conditional expression #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(GrConditionalExpression grConditionalExpression) {
            super.visitConditionalExpression(grConditionalExpression);
            GrConditionalExpression containingConditional = (GrConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)grConditionalExpression, GrConditionalExpression.class);
            if (containingConditional == null) {
                return;
            }
            this.registerError(grConditionalExpression);
        }
    }
}

