/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.EmptyChangelistBuilder;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.MoveRenameReplaceCheck;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final SvnVcs mySvnVcs;

    public SvnRollbackEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    public String getRollbackOperationName() {
        return SvnBundle.message("action.name.revert", new Object[0]);
    }

    public void rollbackChanges(List<Change> changes, final List<VcsException> exceptions, final @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment.rollbackChanges must not be null");
        }
        listener.indeterminate();
        SvnChangeProvider changeProvider = (SvnChangeProvider)this.mySvnVcs.getChangeProvider();
        UnversionedFilesGroupCollector collector = new UnversionedFilesGroupCollector();
        ChangesChecker checker = new ChangesChecker(changeProvider, collector);
        checker.gather(changes);
        exceptions.addAll(checker.getExceptions());
        SVNWCClient client = this.mySvnVcs.createWCClient();
        client.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) {
                File file;
                if (event.getAction() == SVNEventAction.REVERT && (file = event.getFile()) != null) {
                    listener.accept(file);
                }
                if (event.getAction() == SVNEventAction.FAILED_REVERT) {
                    exceptions.add(new VcsException("Revert failed"));
                }
            }

            public void checkCancelled() {
                listener.checkCanceled();
            }
        });
        Reverter reverter = new Reverter(client, exceptions);
        reverter.revert(checker.getForAdds(), true);
        reverter.revert(checker.getForDeletes(), true);
        List<File> edits = checker.getForEdits();
        reverter.revert(edits.toArray(new File[edits.size()]), false);
        List<Trinity<File, File, File>> fromTo = collector.getFromTo();
        for (Trinity<File, File, File> trinity : fromTo) {
            if (!((File)trinity.getFirst()).exists()) continue;
            ((File)trinity.getSecond()).renameTo((File)trinity.getThird());
        }
        List<Pair<File, File>> toBeDeleted = collector.getToBeDeleted();
        for (Pair<File, File> pair : toBeDeleted) {
            if (!((File)pair.getFirst()).exists()) continue;
            FileUtil.delete((File)((File)pair.getSecond()));
        }
    }

    public void rollbackMissingFileDeletion(List<FilePath> filePaths, List<VcsException> exceptions, RollbackProgressListener listener) {
        SVNWCClient wcClient = this.mySvnVcs.createWCClient();
        List files = ChangesUtil.filePathsToFiles(filePaths);
        for (File file : files) {
            listener.accept(file);
            try {
                SVNInfo info = wcClient.doInfo(file, SVNRevision.BASE);
                if (info != null && info.getKind() == SVNNodeKind.FILE) {
                    wcClient.doRevert(file, false);
                    continue;
                }
                this.mySvnVcs.createUpdateClient().doUpdate(file, SVNRevision.HEAD, true);
            }
            catch (SVNException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
        }
    }

    private static class ChangesChecker {
        private final SuperfluousRemover myForAdds;
        private final SuperfluousRemover myForDeletes;
        private final List<File> myForEdits;
        private final SvnChangeProvider myChangeProvider;
        private final UnversionedFilesGroupCollector myCollector;
        private final List<VcsException> myExceptions;

        private ChangesChecker(SvnChangeProvider changeProvider, UnversionedFilesGroupCollector collector) {
            this.myChangeProvider = changeProvider;
            this.myCollector = collector;
            this.myForAdds = new SuperfluousRemover(){

                @Override
                @Nullable
                protected File accept(Change change) {
                    ContentRevision beforeRevision = change.getBeforeRevision();
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (beforeRevision == null || MoveRenameReplaceCheck.check(change)) {
                        return afterRevision.getFile().getIOFile();
                    }
                    return null;
                }
            };
            this.myForDeletes = new SuperfluousRemover(){

                @Override
                @Nullable
                protected File accept(Change change) {
                    ContentRevision beforeRevision = change.getBeforeRevision();
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (afterRevision == null || MoveRenameReplaceCheck.check(change)) {
                        return beforeRevision.getFile().getIOFile();
                    }
                    return null;
                }
            };
            this.myForEdits = new ArrayList<File>();
            this.myExceptions = new ArrayList<VcsException>();
        }

        public void gather(List<Change> changes) {
            for (Change change : changes) {
                ContentRevision beforeRevision = change.getBeforeRevision();
                ContentRevision afterRevision = change.getAfterRevision();
                if (MoveRenameReplaceCheck.check(change)) {
                    this.myCollector.setBefore(beforeRevision.getFile().getIOFile(), afterRevision.getFile().getIOFile());
                    try {
                        this.myChangeProvider.getChanges(afterRevision.getFile(), false, (ChangelistBuilder)this.myCollector);
                    }
                    catch (SVNException e) {
                        this.myExceptions.add(new VcsException((Throwable)e));
                    }
                }
                boolean checked = this.getAddDelete(this.myForAdds, change);
                if (checked |= this.getAddDelete(this.myForDeletes, change)) continue;
                this.myForEdits.add(afterRevision.getFile().getIOFile());
            }
        }

        private boolean getAddDelete(SuperfluousRemover superfluousRemover, Change change) {
            File file = superfluousRemover.accept(change);
            if (file != null) {
                superfluousRemover.check(file);
                return true;
            }
            return false;
        }

        public File[] getForAdds() {
            return this.convert(this.myForAdds.getParentPaths());
        }

        public File[] getForDeletes() {
            return this.convert(this.myForDeletes.getParentPaths());
        }

        private File[] convert(Collection<File> paths) {
            return paths.toArray(new File[paths.size()]);
        }

        public List<VcsException> getExceptions() {
            return this.myExceptions;
        }

        public List<File> getForEdits() {
            return this.myForEdits;
        }
    }

    private static abstract class SuperfluousRemover {
        private final Set<File> myParentPaths = new HashSet<File>();

        private SuperfluousRemover() {
        }

        @Nullable
        protected abstract File accept(Change var1);

        public void check(File file) {
            Iterator<File> iterator = this.myParentPaths.iterator();
            while (iterator.hasNext()) {
                File parentPath = iterator.next();
                if (VfsUtil.isAncestor((File)parentPath, (File)file, (boolean)true)) {
                    return;
                }
                if (!VfsUtil.isAncestor((File)file, (File)parentPath, (boolean)true)) continue;
                iterator.remove();
                while (iterator.hasNext()) {
                    File innerParentPath = iterator.next();
                    if (!VfsUtil.isAncestor((File)file, (File)innerParentPath, (boolean)true)) continue;
                    iterator.remove();
                }
            }
            this.myParentPaths.add(file);
        }

        public Set<File> getParentPaths() {
            return this.myParentPaths;
        }
    }

    private static class UnversionedFilesGroupCollector
    extends EmptyChangelistBuilder {
        private File myCurrentBeforeFile;
        private final List<Pair<File, File>> myToBeDeleted;
        private final List<Trinity<File, File, File>> myFromTo = new ArrayList<Trinity<File, File, File>>();

        private UnversionedFilesGroupCollector() {
            this.myToBeDeleted = new ArrayList<Pair<File, File>>();
        }

        public void processUnversionedFile(VirtualFile file) {
            File to = new File(this.myCurrentBeforeFile, file.getName());
            this.myFromTo.add((Trinity<File, File, File>)new Trinity((Object)this.myCurrentBeforeFile, (Object)new File(file.getPath()), (Object)to));
        }

        public void setBefore(@NotNull File beforeFile, @NotNull File afterFile) {
            if (beforeFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment$UnversionedFilesGroupCollector.setBefore must not be null");
            }
            if (afterFile == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment$UnversionedFilesGroupCollector.setBefore must not be null");
            }
            this.myCurrentBeforeFile = beforeFile;
            this.myToBeDeleted.add((Pair<File, File>)new Pair((Object)beforeFile, (Object)afterFile));
        }

        public List<Pair<File, File>> getToBeDeleted() {
            return this.myToBeDeleted;
        }

        public List<Trinity<File, File, File>> getFromTo() {
            return this.myFromTo;
        }
    }

    private static class Reverter {
        private final SVNWCClient myClient;
        private final List<VcsException> myExceptions;

        private Reverter(SVNWCClient client, List<VcsException> exceptions) {
            this.myClient = client;
            this.myExceptions = exceptions;
        }

        public void revert(File[] files, boolean recursive) {
            block3: {
                if (files.length == 0) {
                    return;
                }
                try {
                    this.myClient.doRevert(files, recursive);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) break block3;
                    this.myExceptions.add(new VcsException((Throwable)e));
                }
            }
        }
    }
}

