/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.util.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.mergeinfo.SelectRootListener;

public class SelectBranchAction
extends LabeledComboBoxAction
implements SelectRootListener,
Getter<WCInfoWithBranches.Branch> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.mergeinfo.SelectBranchAction");
    private final DecoratorManager myManager;
    private WCInfoWithBranches mySelectedRoot;
    public static final DefaultComboBoxModel EMPTY = new DefaultComboBoxModel();
    private final Consumer<String> mySelectionListener;

    public SelectBranchAction(DecoratorManager manager, Consumer<String> selectionListener) {
        super(SvnBundle.message("committed.changes.action.merge.highlighting.select.branch", new Object[0]));
        this.myManager = manager;
        this.mySelectionListener = selectionListener;
    }

    protected void selectionChanged(Object selection) {
        this.mySelectionListener.consume((Object)((WCInfoWithBranches.Branch)selection).getUrl());
        this.myManager.repaintTree();
    }

    @Override
    public void selectionChanged(WCInfoWithBranches wcInfoWithBranches) {
        boolean valueChanges = wcInfoWithBranches != null && !wcInfoWithBranches.equals(this.mySelectedRoot);
        this.mySelectedRoot = wcInfoWithBranches;
        if (valueChanges) {
            ComboBoxModel model = this.createModel();
            this.setModel(model);
            this.myManager.repaintTree();
        }
    }

    @Override
    public void force(WCInfoWithBranches info) {
        this.mySelectedRoot = info;
        if (info == null) {
            this.setModel(EMPTY);
        } else {
            WCInfoWithBranches.Branch selected = (WCInfoWithBranches.Branch)this.getSelected();
            ComboBoxModel model = this.createModel();
            this.setModel(model);
            if (selected != null) {
                boolean selectedSet = false;
                for (int i = 0; i < model.getSize(); ++i) {
                    WCInfoWithBranches.Branch element = (WCInfoWithBranches.Branch)model.getElementAt(i);
                    if (!selected.equals(element)) continue;
                    model.setSelectedItem(element);
                    selectedSet = true;
                }
                if (!selectedSet) {
                    model.setSelectedItem(model.getElementAt(0));
                }
            } else if (model.getSize() > 0) {
                model.setSelectedItem(model.getElementAt(0));
            }
        }
        this.myManager.repaintTree();
    }

    protected ComboBoxModel createModel() {
        if (this.mySelectedRoot == null) {
            return EMPTY;
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(this.mySelectedRoot.getBranches().toArray());
        if (model.getSize() > 0) {
            this.selectionChanged(model.getElementAt(0));
        }
        return model;
    }

    public void enable(boolean value) {
        this.myManager.repaintTree();
    }

    public WCInfoWithBranches.Branch get() {
        return (WCInfoWithBranches.Branch)this.getSelected();
    }
}

