/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.PointMerger;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;

public class ChangeSetMergerFactory
implements MergerFactory {
    private final CommittedChangeList mySelectedList;
    private final List<Change> mySelectedChanges;

    public ChangeSetMergerFactory(CommittedChangeList selectedList, List<Change> selectedChanges) {
        this.mySelectedList = selectedList;
        this.mySelectedChanges = new ArrayList<Change>(selectedChanges);
    }

    @Override
    public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
        return new PointMerger(vcs, this.mySelectedList, target, handler, currentBranchUrl, this.mySelectedChanges, branchName);
    }

    @Override
    public List<CommittedChangeList> getListsToMerge() {
        return Collections.singletonList(this.mySelectedList);
    }

    @Override
    public boolean isMergeAll() {
        return false;
    }
}

