/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenSchemaProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;
import org.jetbrains.idea.maven.dom.references.MavenPsiReference;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenIcons;

public class MavenPropertyPsiReference
extends MavenPsiReference {
    private static final Set<String> BASEDIR_PROPS = new THashSet(Arrays.asList("basedir", "project.basedir", "pom.basedir", "baseUri", "project.baseUri", "pom.baseUri"));
    private static final String TIMESTAMP_PROP = "maven.build.timestamp";
    protected final MavenDomProjectModel myProjectDom;
    protected final MavenProject myMavenProject;
    private final boolean mySoft;

    public MavenPropertyPsiReference(MavenProject mavenProject, PsiElement element, String text, TextRange range, boolean isSoft) {
        super(element, text, range);
        this.myMavenProject = mavenProject;
        this.mySoft = isSoft;
        this.myProjectDom = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile());
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement result = this.doResolve();
        if (result == null) {
            return result;
        }
        if (result instanceof XmlTag) {
            XmlTagChild[] children = ((XmlTag)result).getValue().getChildren();
            if (children.length != 1 || !(children[0] instanceof Navigatable)) {
                return result;
            }
            return new MavenPsiElementWrapper(result, (Navigatable)children[0]);
        }
        return result;
    }

    @Nullable
    protected PsiElement doResolve() {
        if (this.myText.startsWith("env.")) {
            return this.resolveEnvPropety();
        }
        if (BASEDIR_PROPS.contains(this.myText)) {
            return this.resolveBasedir();
        }
        if (this.myText.equals(TIMESTAMP_PROP)) {
            return this.myElement;
        }
        PsiElement result = this.resolveSystemPropety();
        if (result != null) {
            return result;
        }
        result = MavenDomProjectProcessorUtils.searchProperty(this.myText, this.myProjectDom, this.myProject);
        if (result != null) {
            return result;
        }
        if (this.myText.startsWith("settings.")) {
            return this.resolveSettingsModelProperty();
        }
        String modelProperty = this.myText;
        if (!modelProperty.startsWith("project.")) {
            modelProperty = modelProperty.startsWith("pom.") ? "project." + modelProperty.substring("pom.".length()) : "project." + modelProperty;
        }
        return this.resolveModelProperty(this.myProjectDom, modelProperty, (Set<DomElement>)new THashSet());
    }

    @Nullable
    private PsiElement resolveSystemPropety() {
        return MavenDomUtil.findProperty(this.myProject, "System.properties", this.myText);
    }

    @Nullable
    private PsiElement resolveEnvPropety() {
        return MavenDomUtil.findProperty(this.myProject, "Environment.properties", this.myText.substring("env.".length()));
    }

    @Nullable
    private PsiElement resolveBasedir() {
        return this.getBaseDir();
    }

    private PsiDirectory getBaseDir() {
        return PsiManager.getInstance((Project)this.myProject).findDirectory(this.myMavenProject.getDirectoryFile());
    }

    @Nullable
    private PsiElement resolveSettingsModelProperty() {
        if (!this.schemaHasProperty("http://maven.apache.org/xsd/settings-1.0.0.xsd", this.myText)) {
            return null;
        }
        for (VirtualFile each : this.myProjectsManager.getGeneralSettings().getEffectiveSettingsFiles()) {
            XmlTag result;
            MavenDomSettingsModel settingsDom = MavenDomUtil.getMavenDomModel(this.myProject, each, MavenDomSettingsModel.class);
            if (settingsDom == null || (result = MavenDomUtil.findTag(settingsDom, this.myText)) == null) continue;
            return result;
        }
        return this.myElement;
    }

    @Nullable
    private PsiElement resolveModelProperty(@NotNull MavenDomProjectModel projectDom, final @NotNull String path, final @NotNull Set<DomElement> recursionGuard) {
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference.resolveModelProperty must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference.resolveModelProperty must not be null");
        }
        if (recursionGuard == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference.resolveModelProperty must not be null");
        }
        if (recursionGuard.contains(projectDom)) {
            return null;
        }
        recursionGuard.add(projectDom);
        if (!this.schemaHasProperty("http://maven.apache.org/xsd/maven-4.0.0.xsd", path)) {
            return null;
        }
        XmlTag result = MavenDomUtil.findTag(projectDom, path);
        if (result != null) {
            return result;
        }
        if (path.equals("project.groupId") || path.equals("project.version")) {
            return MavenDomUtil.findTag(projectDom, path.replace("project.", "project.parent."));
        }
        result = (PsiElement)new MyMavenParentProjectFileProcessor<PsiElement>(){

            @Override
            protected PsiElement doProcessParent(VirtualFile parentFile) {
                MavenDomProjectModel parentProjectDom = MavenDomUtil.getMavenDomProjectModel(MavenPropertyPsiReference.this.myProject, parentFile);
                return MavenPropertyPsiReference.this.resolveModelProperty(parentProjectDom, path, recursionGuard);
            }
        }.process(projectDom);
        if (result != null) {
            return result;
        }
        return this.myElement;
    }

    private boolean schemaHasProperty(String schema, final String property) {
        return this.processSchema(schema, new SchemaProcessor<Boolean>(){

            @Override
            @Nullable
            public Boolean process(@NotNull String eachProperty, XmlElementDescriptor descriptor) {
                if (eachProperty == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference$2.process must not be null");
                }
                if (eachProperty.equals(property)) {
                    return true;
                }
                return null;
            }
        }) != null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.myRange, newElementName);
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<Object> result = new ArrayList<Object>();
        this.collectVariants(result);
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference.getVariants must not return null");
        }
        return objectArray;
    }

    protected void collectVariants(List<Object> result) {
        this.collectStandardVariants(result);
        this.collectProjectSchemaVariants(result);
        this.collectSettingsXmlSchemaVariants(result);
        this.collectPropertiesVariants(result);
        this.collectSystemEnvProperties("System.properties", null, result);
        this.collectSystemEnvProperties("Environment.properties", "env.", result);
    }

    private void collectStandardVariants(List<Object> result) {
        PsiDirectory basedir = this.getBaseDir();
        for (String each : BASEDIR_PROPS) {
            result.add(MavenPropertyPsiReference.createLookupElement(basedir, each, MavenIcons.MAVEN_ICON));
        }
        result.add(MavenPropertyPsiReference.createLookupElement(this.myElement, TIMESTAMP_PROP, MavenIcons.MAVEN_ICON));
    }

    private void collectProjectSchemaVariants(List<Object> result) {
        this.processSchema("http://maven.apache.org/xsd/maven-4.0.0.xsd", new CollectingSchemaProcessor(result){

            @Override
            public Object process(@NotNull String property, XmlElementDescriptor descriptor) {
                if (property == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference$3.process must not be null");
                }
                super.process(property, descriptor);
                String prefix = "project.";
                if (property.length() > prefix.length()) {
                    String unqualified = property.substring(prefix.length());
                    super.process("pom." + unqualified, descriptor);
                    super.process(unqualified, descriptor);
                }
                return null;
            }
        });
    }

    private void collectSettingsXmlSchemaVariants(List<Object> result) {
        this.processSchema("http://maven.apache.org/xsd/settings-1.0.0.xsd", new CollectingSchemaProcessor(result));
    }

    private void collectPropertiesVariants(List<Object> result) {
        Set<XmlTag> properties = MavenDomProjectProcessorUtils.collectProperties(this.myProjectDom, this.myProject);
        result.addAll(ContainerUtil.map(properties, (Function)new Function<XmlTag, LookupElement>(){

            public LookupElement fun(XmlTag xmlTag) {
                return MavenPropertyPsiReference.createLookupElement(xmlTag, xmlTag.getName());
            }
        }));
    }

    private void collectSystemEnvProperties(String propertiesFileName, String prefix, List<Object> result) {
        PropertiesFile file = MavenDomUtil.getPropertiesFile(this.myProject, propertiesFileName);
        this.collectPropertiesFileVariants(file, prefix, result);
    }

    protected void collectPropertiesFileVariants(PropertiesFile file, String prefix, List<Object> result) {
        for (Property each : file.getProperties()) {
            String name = each.getKey();
            if (prefix != null) {
                name = prefix + name;
            }
            result.add(MavenPropertyPsiReference.createLookupElement(each, name));
        }
    }

    private static LookupElement createLookupElement(Object element, String name) {
        return MavenPropertyPsiReference.createLookupElement(element, name, Icons.PROPERTY_ICON);
    }

    private static LookupElement createLookupElement(Object element, String name, Icon icon) {
        return LookupElementBuilder.create((Object)element, (String)name).setIcon(icon).setPresentableText(name);
    }

    @Nullable
    private <T> T processSchema(String schema, SchemaProcessor<T> processor) {
        VirtualFile file = MavenSchemaProvider.getSchemaFile(schema);
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        XmlDocument document = xmlFile.getDocument();
        XmlNSDescriptor desc = (XmlNSDescriptor)document.getMetaData();
        XmlElementDescriptor[] descriptors = desc.getRootElementsDescriptors(document);
        return MavenPropertyPsiReference.doProcessSchema(descriptors, null, processor, (Set<XmlElementDescriptor>)new THashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doProcessSchema(XmlElementDescriptor[] descriptors, String prefix, SchemaProcessor<T> processor, Set<XmlElementDescriptor> recursionGuard) {
        for (XmlElementDescriptor each : descriptors) {
            if (MavenPropertyPsiReference.isCollection(each) || recursionGuard.contains(each)) continue;
            recursionGuard.add(each);
            try {
                T result;
                String name = each.getName();
                if (prefix != null) {
                    name = prefix + "." + name;
                }
                if ((result = processor.process(name, each)) != null) {
                    T t = result;
                    return t;
                }
                result = MavenPropertyPsiReference.doProcessSchema(each.getElementsDescriptors(null), name, processor, recursionGuard);
                if (result == null) continue;
                T t = result;
                return t;
            }
            finally {
                recursionGuard.remove(each);
            }
        }
        return null;
    }

    private static <T> boolean isCollection(XmlElementDescriptor each) {
        XmlTag complexType;
        XmlTag declaration = (XmlTag)each.getDeclaration();
        return declaration != null && (complexType = declaration.findFirstSubTag("xs:complexType")) != null && complexType.findFirstSubTag("xs:sequence") != null;
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    private abstract class MyMavenParentProjectFileProcessor<T>
    extends MavenParentProjectFileProcessor<T> {
        private MyMavenParentProjectFileProcessor() {
        }

        @Override
        protected VirtualFile findManagedFile(@NotNull MavenId id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference$MyMavenParentProjectFileProcessor.findManagedFile must not be null");
            }
            MavenProject project = MavenPropertyPsiReference.this.myProjectsManager.findProject(id);
            return project == null ? null : project.getFile();
        }

        @Nullable
        public T process(@NotNull MavenDomProjectModel projectDom) {
            if (projectDom == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference$MyMavenParentProjectFileProcessor.process must not be null");
            }
            MavenDomParent parent = projectDom.getMavenParent();
            MavenParentDesc parentDesc = null;
            if (DomUtil.hasXml((DomElement)parent)) {
                String parentGroupId = parent.getGroupId().getStringValue();
                String parentArtifactId = parent.getArtifactId().getStringValue();
                String parentVersion = parent.getVersion().getStringValue();
                String parentRelativePath = parent.getRelativePath().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)parentRelativePath)) {
                    parentRelativePath = "../pom.xml";
                }
                MavenId parentId = new MavenId(parentGroupId, parentArtifactId, parentVersion);
                parentDesc = new MavenParentDesc(parentId, parentRelativePath);
            }
            return (T)this.process(MavenPropertyPsiReference.this.myProjectsManager.getGeneralSettings(), MavenDomUtil.getVirtualFile(projectDom), parentDesc);
        }
    }

    private static class CollectingSchemaProcessor
    implements SchemaProcessor {
        private final List<Object> myResult;

        public CollectingSchemaProcessor(List<Object> result) {
            this.myResult = result;
        }

        @Nullable
        public Object process(@NotNull String property, XmlElementDescriptor descriptor) {
            if (property == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference$CollectingSchemaProcessor.process must not be null");
            }
            this.myResult.add(MavenPropertyPsiReference.createLookupElement(descriptor, property, MavenIcons.MAVEN_ICON));
            return null;
        }
    }

    private static interface SchemaProcessor<T> {
        @Nullable
        public T process(@NotNull String var1, XmlElementDescriptor var2);
    }
}

