/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.project.MavenId;

public class MavenArtifactCoordinatesArtifactIdConverter
extends MavenArtifactCoordinatesConverter {
    @Override
    protected boolean doIsValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId())) {
            return false;
        }
        return manager.hasArtifactId(id.getGroupId(), id.getArtifactId());
    }

    @Override
    protected Set<String> doGetVariants(MavenId id, MavenProjectIndicesManager manager) {
        if (StringUtil.isEmptyOrSpaces((String)id.getGroupId())) {
            return Collections.emptySet();
        }
        return manager.getArtifactIds(id.getGroupId());
    }
}

