/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.MoreIcon;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayoutStrategy;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class SingleRowLayout
extends TabLayout {
    JBTabsImpl myTabs;
    public SingleRowPassInfo myLastSingRowLayout;
    final SingleRowLayoutStrategy myTop;
    final SingleRowLayoutStrategy myLeft;
    final SingleRowLayoutStrategy myBottom;
    final SingleRowLayoutStrategy myRight;
    public MoreIcon myMoreIcon = new MoreIcon(){

        @Override
        protected boolean isActive() {
            return SingleRowLayout.this.myTabs.myFocused;
        }

        @Override
        protected Rectangle getIconRec() {
            return SingleRowLayout.this.myLastSingRowLayout != null ? SingleRowLayout.this.myLastSingRowLayout.moreRect : null;
        }
    };
    public JPopupMenu myMorePopup;
    public GhostComponent myLeftGhost = new GhostComponent(RowDropPolicy.first, RowDropPolicy.first);
    public GhostComponent myRightGhost = new GhostComponent(RowDropPolicy.last, RowDropPolicy.first);
    private RowDropPolicy myRowDropPolicy = RowDropPolicy.first;

    @Override
    public boolean isSideComponentOnTabs() {
        return this.getStrategy().isSideComponentOnTabs();
    }

    @Override
    public ShapeTransform createShapeTransform(Rectangle labelRec) {
        return this.getStrategy().createShapeTransform(labelRec);
    }

    public SingleRowLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
        this.myTop = new SingleRowLayoutStrategy.Top(this);
        this.myLeft = new SingleRowLayoutStrategy.Left(this);
        this.myBottom = new SingleRowLayoutStrategy.Bottom(this);
        this.myRight = new SingleRowLayoutStrategy.Right(this);
    }

    SingleRowLayoutStrategy getStrategy() {
        switch (this.myTabs.getPresentation().getTabsPosition()) {
            case top: {
                return this.myTop;
            }
            case left: {
                return this.myLeft;
            }
            case bottom: {
                return this.myBottom;
            }
            case right: {
                return this.myRight;
            }
        }
        return null;
    }

    private boolean checkLayoutLabels() {
        boolean layoutLabels = true;
        if (!this.myTabs.myForcedRelayout && this.myLastSingRowLayout != null && this.myLastSingRowLayout.contentCount == this.myTabs.getTabCount() && this.myLastSingRowLayout.laayoutSize.equals(this.myTabs.getSize())) {
            TabInfo each;
            TabLabel eachLabel;
            Iterator<TabInfo> i$ = this.myTabs.myVisibleInfos.iterator();
            while (i$.hasNext() && (eachLabel = this.myTabs.myInfo2Label.get(each = i$.next())).isValid()) {
                if (this.myTabs.getSelectedInfo() != each || eachLabel.getBounds().width == 0) continue;
                layoutLabels = false;
            }
        }
        return layoutLabels;
    }

    public LayoutPassInfo layoutSingleRow() {
        SingleRowPassInfo data = new SingleRowPassInfo(this);
        TabInfo selected = this.myTabs.getSelectedInfo();
        JBTabsImpl.Toolbar selectedToolbar = this.myTabs.myInfo2Toolbar.get(selected);
        boolean layoutLabels = this.checkLayoutLabels();
        if (!layoutLabels) {
            data = this.myLastSingRowLayout;
        }
        data.insets = this.myTabs.getLayoutInsets();
        data.hToolbar = selectedToolbar != null && this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null;
        data.vToolbar = selectedToolbar != null && !this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null;
        this.myTabs.resetLayout(layoutLabels || this.myTabs.isHideTabs());
        if (layoutLabels && !this.myTabs.isHideTabs()) {
            data.position = this.getStrategy().getStartPosition(data);
            this.recomputeToLayout(data);
            this.layoutLabelsAndGhosts(data);
            if (data.toDrop.size() > 0) {
                data.moreRect = this.getStrategy().getMoreRect(data);
            }
        }
        if (selected != null) {
            data.comp = selected.getComponent();
            this.getStrategy().layoutComp(data);
        }
        if (data.toLayout.size() > 0 && this.myTabs.myVisibleInfos.size() > 0) {
            int left = this.myTabs.myVisibleInfos.indexOf(data.toLayout.get(0));
            int right = this.myTabs.myVisibleInfos.indexOf(data.toLayout.get(data.toLayout.size() - 1));
            this.myMoreIcon.setPaintedIcons(left > 0, right < this.myTabs.myVisibleInfos.size() - 1);
        } else {
            this.myMoreIcon.setPaintedIcons(false, false);
        }
        data.tabRectangle = new Rectangle();
        if (data.toLayout.size() > 0) {
            TabLabel firstLabel = this.myTabs.myInfo2Label.get(data.toLayout.get(0));
            TabLabel lastLabel = this.myTabs.myInfo2Label.get(data.toLayout.get(data.toLayout.size() - 1));
            if (firstLabel != null && lastLabel != null) {
                data.tabRectangle.x = firstLabel.getBounds().x;
                data.tabRectangle.y = firstLabel.getBounds().y;
                data.tabRectangle.width = (int)lastLabel.getBounds().getMaxX() - data.tabRectangle.x;
                data.tabRectangle.height = (int)lastLabel.getBounds().getMaxY() - data.tabRectangle.y;
            }
        }
        this.myLastSingRowLayout = data;
        return data;
    }

    private void layoutLabelsAndGhosts(SingleRowPassInfo data) {
        int fixedPosition = this.getStrategy().getFixedPosition(data);
        boolean reachedBounds = false;
        if (data.firstGhostVisible || this.myTabs.isGhostsAlwaysVisible()) {
            data.firstGhost = this.getStrategy().getLayoutRec(data.position, fixedPosition, this.myTabs.getGhostTabLength(), this.getStrategy().getFixedFitLength(data));
            JBTabsImpl.layout(this.myLeftGhost, data.firstGhost);
            data.position += this.getStrategy().getLengthIncrement(data.firstGhost.getSize());
        }
        int deltaToFit = 0;
        if ((data.firstGhostVisible || data.lastGhostVisible) && data.requiredLength < data.toFitLength && this.getStrategy().canBeStretched()) {
            deltaToFit = (int)Math.floor((double)(data.toFitLength - data.requiredLength) / (double)data.toLayout.size());
        }
        int totalLength = 0;
        int positionStart = data.position;
        for (TabInfo eachInfo : data.toLayout) {
            boolean isLast;
            TabLabel label = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension eachSize = label.getPreferredSize();
            boolean bl = isLast = data.toLayout.indexOf(eachInfo) == data.toLayout.size() - 1;
            if (!isLast || deltaToFit == 0) {
                Rectangle rec = this.getStrategy().getLayoutRec(data.position, fixedPosition, this.getStrategy().getLengthIncrement(eachSize) + deltaToFit, this.getStrategy().getFixedFitLength(data));
                JBTabsImpl.layout(label, rec);
            } else {
                int length = data.toFitLength - totalLength;
                Rectangle rec = this.getStrategy().getLayoutRec(data.position, fixedPosition, length, this.getStrategy().getFixedFitLength(data));
                JBTabsImpl.layout(label, rec);
            }
            label.setAligmentToCenter(deltaToFit > 0 && this.getStrategy().isToCenterTextWhenStretched());
            data.position = this.getStrategy().getMaxPosition(label.getBounds());
            ++data.position;
            totalLength = this.getStrategy().getMaxPosition(label.getBounds()) - positionStart;
        }
        for (TabInfo eachInfo : data.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
        if (data.lastGhostVisible || this.myTabs.isGhostsAlwaysVisible()) {
            data.lastGhost = this.getStrategy().getLayoutRec(data.position, fixedPosition, this.myTabs.getGhostTabLength(), this.getStrategy().getFixedFitLength(data));
            JBTabsImpl.layout(this.myRightGhost, data.lastGhost);
        }
    }

    private void recomputeToLayout(SingleRowPassInfo data) {
        data.toFitLength = this.getStrategy().getToFitLength(data);
        if (this.myTabs.isGhostsAlwaysVisible()) {
            data.toFitLength -= this.myTabs.getGhostTabLength() * 2;
        }
        for (TabInfo eachInfo : this.myTabs.myVisibleInfos) {
            data.requiredLength += this.getStrategy().getLengthIncrement(this.myTabs.myInfo2Label.get(eachInfo).getPreferredSize());
            data.toLayout.add(eachInfo);
        }
        while (data.requiredLength > data.toFitLength - data.position && data.toLayout.size() != 0) {
            TabInfo first = data.toLayout.get(0);
            TabInfo last = data.toLayout.get(data.toLayout.size() - 1);
            if (this.myRowDropPolicy == RowDropPolicy.first) {
                if (first != this.myTabs.getSelectedInfo()) {
                    this.processDrop(data, first, true);
                    continue;
                }
                if (last == this.myTabs.getSelectedInfo()) break;
                this.processDrop(data, last, false);
                continue;
            }
            if (last != this.myTabs.getSelectedInfo()) {
                this.processDrop(data, last, false);
                continue;
            }
            if (first == this.myTabs.getSelectedInfo()) break;
            this.processDrop(data, first, true);
        }
        for (int i = 1; i < this.myTabs.myVisibleInfos.size() - 1; ++i) {
            TabInfo each = this.myTabs.myVisibleInfos.get(i);
            TabInfo prev = this.myTabs.myVisibleInfos.get(i - 1);
            TabInfo next = this.myTabs.myVisibleInfos.get(i + 1);
            if (data.toLayout.contains(each) && data.toDrop.contains(prev)) {
                this.myLeftGhost.setInfo(prev);
                continue;
            }
            if (!data.toLayout.contains(each) || !data.toDrop.contains(next)) continue;
            this.myRightGhost.setInfo(next);
        }
    }

    private void processDrop(SingleRowPassInfo data, TabInfo info, boolean isFirstSide) {
        data.requiredLength -= this.getStrategy().getLengthIncrement(this.myTabs.myInfo2Label.get(info).getPreferredSize());
        data.toDrop.add(info);
        data.toLayout.remove(info);
        if (data.toDrop.size() == 1) {
            data.toFitLength -= data.moreRectAxisSize;
        }
        if (!data.firstGhostVisible && isFirstSide) {
            data.firstGhostVisible = true;
            if (!this.myTabs.isGhostsAlwaysVisible()) {
                data.toFitLength -= this.myTabs.getGhostTabLength();
            }
        } else if (!data.lastGhostVisible && !isFirstSide) {
            data.lastGhostVisible = true;
            if (!this.myTabs.isGhostsAlwaysVisible()) {
                data.toFitLength -= this.myTabs.getGhostTabLength();
            }
        }
    }

    public class GhostComponent
    extends JLabel {
        private TabInfo myInfo;

        private GhostComponent(final RowDropPolicy before, final RowDropPolicy after) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SingleRowLayout.this.myTabs.isSelectionClick(e, true) && GhostComponent.this.myInfo != null) {
                        SingleRowLayout.this.myRowDropPolicy = before;
                        SingleRowLayout.this.myTabs.select(GhostComponent.this.myInfo, true).doWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                SingleRowLayout.this.myRowDropPolicy = after;
                            }
                        });
                    }
                }
            });
        }

        public void setInfo(TabInfo info) {
            this.myInfo = info;
            this.setToolTipText(info != null ? info.getTooltipText() : null);
        }

        public void reset() {
            JBTabsImpl cfr_ignored_0 = SingleRowLayout.this.myTabs;
            JBTabsImpl.resetLayout(this);
            this.setInfo(null);
        }
    }

    private static enum RowDropPolicy {
        first,
        last;

    }
}

