/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    public static final Key<FoldingBuilder> FOLDING_BUILDER = new Key("FOLDING_BUILDER");
    private final List<FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @Override
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/folding/CompositeFoldingBuilder.buildFoldRegions must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/folding/CompositeFoldingBuilder.buildFoldRegions must not be null");
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        for (FoldingBuilder builder : this.myBuilders) {
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors(builder, root, document, quick)) {
                descriptor.getElement().putUserData(FOLDING_BUILDER, builder);
                descriptors.add(descriptor);
            }
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/folding/CompositeFoldingBuilder.buildFoldRegions must not return null");
        }
        return foldingDescriptorArray;
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/folding/CompositeFoldingBuilder.getPlaceholderText must not be null");
        }
        FoldingBuilder builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER);
        return builder == null ? node.getText() : builder.getPlaceholderText(node);
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/folding/CompositeFoldingBuilder.isCollapsedByDefault must not be null");
        }
        FoldingBuilder builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER);
        return builder != null && builder.isCollapsedByDefault(node);
    }
}

