/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;

public class CloseAction
extends AnAction
implements DumbAware {
    private RunContentDescriptor myContentDescriptor;
    private final Project myProject;
    private Executor myExecutor;

    public CloseAction(Executor executor, RunContentDescriptor contentDescriptor, Project project) {
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myProject = project;
        this.copyFrom(ActionManager.getInstance().getAction("CloseActiveTab"));
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setIcon(IconLoader.getIcon((String)"/actions/cancel.png"));
        templatePresentation.setText(ExecutionBundle.message("close.tab.action.name", new Object[0]));
        templatePresentation.setDescription(null);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        if (this.myContentDescriptor == null) {
            return;
        }
        boolean removedOk = ExecutionManager.getInstance(this.myProject).getContentManager().removeRunContent(this.myExecutor, this.myContentDescriptor);
        if (removedOk) {
            this.myContentDescriptor = null;
            this.myExecutor = null;
        }
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.myContentDescriptor != null);
    }
}

