/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDictionary
implements EditableDictionary {
    private static final String DEFAULT_CURRENT_USER_NAME = "default.user";
    private static final String DEFAULT_PROJECT_DICTIONARY_NAME = "project";
    private String activeName;
    private Set<EditableDictionary> dictionaries;

    public ProjectDictionary() {
    }

    public ProjectDictionary(Set<EditableDictionary> dictionaries) {
        this.dictionaries = dictionaries;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getName() {
        return DEFAULT_PROJECT_DICTIONARY_NAME;
    }

    public String getActiveName() {
        return this.activeName;
    }

    public void setActiveName(String name) {
        this.activeName = name;
    }

    @Override
    public boolean contains(String word) {
        if (word == null || this.dictionaries == null) {
            return false;
        }
        for (EditableDictionary dictionary : this.dictionaries) {
            if (!dictionary.contains(word)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addToDictionary(String word) {
        this.getActiveDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getActiveDictionary().removeFromDictionary(word);
    }

    @NotNull
    private EditableDictionary getActiveDictionary() {
        EditableDictionary editableDictionary = this.ensureCurrentUserDictionary();
        if (editableDictionary == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/dictionary/ProjectDictionary.getActiveDictionary must not return null");
        }
        return editableDictionary;
    }

    @NotNull
    private EditableDictionary ensureCurrentUserDictionary() {
        EditableDictionary result;
        if (this.activeName == null) {
            this.activeName = DEFAULT_CURRENT_USER_NAME;
        }
        if ((result = this.getDictionaryByName(this.activeName)) == null) {
            result = new UserDictionary(this.activeName);
            if (this.dictionaries == null) {
                this.dictionaries = new THashSet();
            }
            this.dictionaries.add(result);
        }
        EditableDictionary editableDictionary = result;
        if (editableDictionary == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/dictionary/ProjectDictionary.ensureCurrentUserDictionary must not return null");
        }
        return editableDictionary;
    }

    @Nullable
    private EditableDictionary getDictionaryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/dictionary/ProjectDictionary.getDictionaryByName must not be null");
        }
        if (this.dictionaries == null) {
            return null;
        }
        EditableDictionary result = null;
        for (EditableDictionary dictionary : this.dictionaries) {
            if (!dictionary.getName().equals(name)) continue;
            result = dictionary;
            break;
        }
        return result;
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.getActiveDictionary().replaceAll(words);
    }

    @Override
    public void clear() {
        this.getActiveDictionary().clear();
    }

    @Override
    @Nullable
    public Set<String> getWords() {
        if (this.dictionaries == null) {
            return null;
        }
        HashSet<String> words = new HashSet<String>();
        for (EditableDictionary dictionary : this.dictionaries) {
            words.addAll(dictionary.getWords());
        }
        return words;
    }

    @Override
    public int size() {
        int result = 0;
        for (EditableDictionary dictionary : this.dictionaries) {
            result += dictionary.size();
        }
        return result;
    }

    @Override
    public void traverse(Consumer<String> consumer) {
        if (this.dictionaries == null) {
            return;
        }
        for (EditableDictionary dictionary : this.dictionaries) {
            dictionary.traverse(consumer);
        }
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.getActiveDictionary().getWords();
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getActiveDictionary().addToDictionary(words);
    }

    public Set<EditableDictionary> getDictionaries() {
        return this.dictionaries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDictionary that = (ProjectDictionary)o;
        if (this.activeName != null ? !this.activeName.equals(that.activeName) : that.activeName != null) {
            return false;
        }
        return !(this.dictionaries != null ? !((Object)this.dictionaries).equals(that.dictionaries) : that.dictionaries != null);
    }

    public int hashCode() {
        int result = this.activeName != null ? this.activeName.hashCode() : 0;
        result = 31 * result + (this.dictionaries != null ? ((Object)this.dictionaries).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ProjectDictionary{activeName='" + this.activeName + '\'' + ", dictionaries=" + this.dictionaries + '}';
    }
}

