/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntImport;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.AntTask;
import com.intellij.lang.ant.psi.AntTypeDef;
import com.intellij.lang.ant.psi.impl.AntFilesProviderImpl;
import com.intellij.lang.ant.psi.impl.AntProjectImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PropertiesBuilder
extends AntElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.psi.impl.PropertiesBuilder");
    @NotNull
    private final AntFile myPropertyHolder;
    private final Set<AntTarget> myVisitedTargets;
    private final Set<AntFile> myVisitedFiles;
    private final Map<AntProject, List<Runnable>> myPostponedProcessing;
    private final List<PsiFile> myDependentFiles;

    private PropertiesBuilder(@NotNull AntFile propertyHolder) {
        if (propertyHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/PropertiesBuilder.<init> must not be null");
        }
        this.myVisitedTargets = new HashSet<AntTarget>();
        this.myVisitedFiles = new HashSet<AntFile>();
        this.myPostponedProcessing = new HashMap<AntProject, List<Runnable>>();
        this.myDependentFiles = new ArrayList<PsiFile>();
        this.myPropertyHolder = propertyHolder;
    }

    @Override
    public void visitAntTypedef(AntTypeDef def) {
        def.clearClassesCache();
        def.getDefinitions();
    }

    @Override
    public void visitAntFile(AntFile antFile) {
        if (!this.myVisitedFiles.contains(antFile)) {
            this.myVisitedFiles.add(antFile);
            AntProject project = antFile.getAntProject();
            if (project != null) {
                project.acceptAntElementVisitor(this);
                ((AntProjectImpl)project).clearImports();
            }
        }
    }

    @Override
    public void visitAntTask(AntTask task) {
        if (task instanceof AntProperty) {
            this.visitAntProperty((AntProperty)task);
        } else {
            super.visitAntTask(task);
        }
    }

    @Override
    public void visitAntStructuredElement(AntStructuredElement element) {
        if (element instanceof AntFilesProviderImpl) {
            ((AntFilesProviderImpl)element).clearCachedFiles();
        }
        super.visitAntStructuredElement(element);
    }

    @Override
    public void visitAntProject(AntProject antProject) {
        LinkedHashSet<AntTarget> projectTargets = new LinkedHashSet<AntTarget>();
        for (PsiElement child : antProject.getChildren()) {
            if (!(child instanceof AntElement)) continue;
            if (child instanceof AntTarget) {
                AntTarget antTarget = (AntTarget)child;
                if (!antProject.equals(antTarget.getAntProject())) continue;
                projectTargets.add(antTarget);
                continue;
            }
            ((AntElement)child).acceptAntElementVisitor(this);
        }
        AntTarget entryTarget = antProject.getDefaultTarget();
        if (entryTarget != null) {
            entryTarget.acceptAntElementVisitor(this);
        }
        projectTargets.removeAll(this.myVisitedTargets);
        for (AntTarget antTarget : projectTargets) {
            antTarget.acceptAntElementVisitor(this);
        }
        List<Runnable> list = this.myPostponedProcessing.get(antProject);
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
            this.myPostponedProcessing.remove(antProject);
        }
    }

    @Override
    public void visitAntProperty(AntProperty antProperty) {
        String[] names;
        String environment;
        PropertiesFile propertiesFile = antProperty.getPropertiesFile();
        if (propertiesFile != null) {
            this.myDependentFiles.add((PsiFile)propertiesFile);
        }
        if ((environment = antProperty.getEnvironment()) != null) {
            this.myPropertyHolder.addEnvironmentPropertyPrefix(environment);
        }
        if ((names = antProperty.getNames()) != null) {
            for (String name : names) {
                this.myPropertyHolder.setProperty(name, antProperty);
            }
        }
    }

    @Override
    public void visitAntTarget(AntTarget target) {
        AntTarget[] dependsTargets;
        if (this.myVisitedTargets.contains(target)) {
            return;
        }
        this.myVisitedTargets.add(target);
        for (AntTarget dependsTarget : dependsTargets = target.getDependsTargets()) {
            dependsTarget.acceptAntElementVisitor(this);
        }
        String ifProperty = target.getConditionalPropertyName(AntTarget.ConditionalAttribute.IF);
        if (ifProperty != null && this.myPropertyHolder.getProperty(ifProperty) == null) {
            this.postponeTargetVisiting(target);
            return;
        }
        String unlessProperty = target.getConditionalPropertyName(AntTarget.ConditionalAttribute.UNLESS);
        if (unlessProperty != null && this.myPropertyHolder.getProperty(unlessProperty) != null) {
            this.postponeTargetVisiting(target);
            return;
        }
        this.visitTargetChildren(target);
    }

    private void postponeTargetVisiting(final AntTarget target) {
        AntProject antProject = target.getAntProject();
        List<Runnable> list = this.myPostponedProcessing.get(antProject);
        if (list == null) {
            list = new ArrayList<Runnable>();
            this.myPostponedProcessing.put(antProject, list);
        }
        list.add(new Runnable(){

            @Override
            public void run() {
                PropertiesBuilder.this.visitTargetChildren(target);
            }
        });
    }

    private void visitTargetChildren(AntTarget target) {
        for (PsiElement child : target.getChildren()) {
            if (!(child instanceof AntElement)) continue;
            ((AntElement)child).acceptAntElementVisitor(this);
        }
    }

    @Override
    public void visitAntImport(AntImport antImport) {
        AntFile antFile = antImport.getImportedFile();
        if (antFile != null) {
            this.myDependentFiles.add(antFile);
            this.visitAntFile(antFile);
        }
    }

    public static List<PsiFile> defineProperties(AntFile file) {
        AntProject project = file.getAntProject();
        LOG.assertTrue(project != null);
        PropertiesBuilder builder = new PropertiesBuilder(file);
        file.acceptAntElementVisitor(builder);
        return builder.myDependentFiles;
    }
}

