/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;

public class PluginBuildUtil {
    private PluginBuildUtil() {
    }

    @NonNls
    @Nullable
    public static String getPluginExPath(Module module) {
        Sdk jdk = IdeaJdk.findIdeaJdk(ModuleRootManager.getInstance((Module)module).getSdk());
        if (jdk == null) {
            return null;
        }
        String sandboxHome = ((Sandbox)jdk.getSdkAdditionalData()).getSandboxHome();
        if (sandboxHome == null) {
            return null;
        }
        try {
            sandboxHome = new File(sandboxHome).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        return sandboxHome + File.separator + "plugins" + File.separator + module.getName();
    }

    public static void getDependencies(Module module, Set<Module> modules) {
        for (Module dependency : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            if (dependency.getModuleType() != StdModuleTypes.JAVA || !modules.add(dependency)) continue;
            PluginBuildUtil.getDependencies(dependency, modules);
        }
    }

    public static Module[] getWrongSetDependencies(final Module module) {
        return (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                Module[] projectModules;
                ArrayList<Module> result = new ArrayList<Module>();
                for (Module projectModule : projectModules = ModuleManager.getInstance((Project)module.getProject()).getModules()) {
                    if (ArrayUtil.find((Object[])ModuleRootManager.getInstance((Module)projectModule).getDependencies(), (Object)module) <= -1) continue;
                    result.add(projectModule);
                }
                return result.toArray(new Module[result.size()]);
            }
        });
    }

    public static void getLibraries(Module module, Set<Library> libs) {
        OrderEntry[] orderEntries;
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libEntry = (LibraryOrderEntry)orderEntry;
            Library lib = libEntry.getLibrary();
            DependencyScope scope = libEntry.getScope();
            if (lib == null || scope != DependencyScope.COMPILE && scope != DependencyScope.RUNTIME) continue;
            libs.add(lib);
        }
    }
}

