/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class MakeSerializableFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.class.serializable.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/MakeSerializableFix.getName must not return null");
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement nameElement = descriptor.getPsiElement();
        PsiClass containingClass = ClassUtils.getContainingClass(nameElement);
        assert (containingClass != null);
        PsiManager psiManager = containingClass.getManager();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiJavaCodeReferenceElement referenceElement = elementFactory.createReferenceElementByFQClassName("java.io.Serializable", scope);
        PsiReferenceList implementsList = containingClass.getImplementsList();
        assert (implementsList != null);
        implementsList.add((PsiElement)referenceElement);
    }
}

