/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import org.jetbrains.annotations.NotNull;

public class QuickEvaluateAction
extends XDebuggerActionBase {
    public QuickEvaluateAction() {
        super(true);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/QuickEvaluateAction.getHandler must not be null");
        }
        QuickEvaluateHandlerWrapper quickEvaluateHandlerWrapper = new QuickEvaluateHandlerWrapper(debuggerSupport.getQuickEvaluateHandler());
        if (quickEvaluateHandlerWrapper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/actions/QuickEvaluateAction.getHandler must not return null");
        }
        return quickEvaluateHandlerWrapper;
    }

    private static class QuickEvaluateHandlerWrapper
    extends DebuggerActionHandler {
        private final QuickEvaluateHandler myHandler;

        public QuickEvaluateHandlerWrapper(QuickEvaluateHandler handler) {
            this.myHandler = handler;
        }

        @Override
        public void perform(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/QuickEvaluateAction$QuickEvaluateHandlerWrapper.perform must not be null");
            }
            Editor editor = (Editor)event.getData(PlatformDataKeys.EDITOR);
            if (editor != null) {
                LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
                ValueLookupManager.getInstance(project).showHint(this.myHandler, editor, editor.logicalPositionToXY(logicalPosition), ValueHintType.MOUSE_CLICK_HINT);
            }
        }

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/QuickEvaluateAction$QuickEvaluateHandlerWrapper.isEnabled must not be null");
            }
            return this.myHandler.isEnabled(project);
        }
    }
}

