/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.ByteBufferMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntArrayValueProvider
implements ByteBufferMap.ValueProvider<int[]> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.IntArrayValueProvider");
    public static final IntArrayValueProvider INSTANCE = new IntArrayValueProvider(-1);
    private final int myArraySize;

    public IntArrayValueProvider(int arraySize) {
        this.myArraySize = arraySize;
    }

    @Override
    public void write(DataOutput out, int[] value) throws IOException {
        int[] array = value;
        LOG.assertTrue(this.myArraySize == -1 || array.length == this.myArraySize);
        if (this.myArraySize == -1) {
            out.writeInt(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            out.writeInt(array[i]);
        }
    }

    @Override
    public int length(int[] value) {
        int[] array = value;
        LOG.assertTrue(this.myArraySize == -1 || array.length == this.myArraySize);
        if (this.myArraySize == -1) {
            return 4 * (array.length + 1);
        }
        return 4 * this.myArraySize;
    }

    @Override
    public int[] get(DataInput in) throws IOException {
        int[] result = this.myArraySize >= 0 ? ArrayUtil.newIntArray((int)this.myArraySize) : ArrayUtil.newIntArray((int)in.readInt());
        for (int i = 0; i < result.length; ++i) {
            result[i] = in.readInt();
        }
        return result;
    }
}

