/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.containers.WeakList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class StackingPopupDispatcherImpl
extends StackingPopupDispatcher
implements AWTEventListener,
KeyEventDispatcher {
    private final Stack<JBPopup> myStack = new Stack();
    private final WeakList<JBPopup> myPersistentPopups = new WeakList();
    private final WeakList<JBPopup> myAllPopups = new WeakList();

    private StackingPopupDispatcherImpl() {
    }

    public void onPopupShown(JBPopup popup, boolean inStack) {
        if (inStack) {
            this.myStack.push(popup);
            if (ApplicationManager.getApplication() != null) {
                IdeEventQueue.getInstance().getPopupManager().push((IdePopupEventDispatcher)StackingPopupDispatcherImpl.getInstance());
            }
        } else if (popup.isPersistent()) {
            this.myPersistentPopups.add((Object)popup);
        }
        this.myAllPopups.add((Object)popup);
    }

    public void onPopupHidden(JBPopup popup) {
        boolean wasInStack = this.myStack.remove(popup);
        this.myPersistentPopups.remove((Object)popup);
        if (wasInStack && this.myStack.isEmpty() && ApplicationManager.getApplication() != null) {
            IdeEventQueue.getInstance().getPopupManager().remove((IdePopupEventDispatcher)this);
        }
        this.myAllPopups.remove((Object)popup);
    }

    public void hidePersistentPopups() {
        WeakList<JBPopup> list = this.myPersistentPopups;
        for (JBPopup each : list) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(false);
        }
    }

    public void restorePersistentPopups() {
        WeakList<JBPopup> list = this.myPersistentPopups;
        for (JBPopup each : list) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(true);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.dispatchMouseEvent(event);
    }

    protected boolean dispatchMouseEvent(AWTEvent event) {
        if (event.getID() != 501) {
            return false;
        }
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup = (AbstractPopup)this.findPopup();
        MouseEvent mouseEvent = (MouseEvent)event;
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        while (true) {
            if (popup != null && !popup.isDisposed()) {
                JComponent content = popup.getContent();
                if (!content.isShowing()) {
                    popup.cancel();
                    return false;
                }
                Rectangle bounds = new Rectangle(content.getLocationOnScreen(), content.getSize());
                if (bounds.contains(point) || !popup.isCancelOnClickOutside()) {
                    return false;
                }
                if (!popup.canClose()) {
                    return false;
                }
                popup.cancel(mouseEvent);
            }
            if (this.myStack.isEmpty()) {
                return false;
            }
            popup = (AbstractPopup)this.myStack.peek();
            if (popup != null && !popup.isDisposed()) continue;
            this.myStack.pop();
        }
    }

    protected JBPopup findPopup() {
        while (!this.myStack.isEmpty()) {
            AbstractPopup each = (AbstractPopup)this.myStack.peek();
            if (each == null || each.isDisposed()) {
                this.myStack.pop();
                continue;
            }
            return each;
        }
        return null;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        boolean closeRequest = e.getID() == 401 && e.getKeyCode() == 27 && e.getModifiers() == 0;
        JBPopup popup = closeRequest ? this.findPopup() : this.getFocusedPopup();
        if (popup == null) {
            return false;
        }
        if (closeRequest && popup.isCancelKeyEnabled()) {
            popup.cancel();
            return true;
        }
        return false;
    }

    @Nullable
    public Component getComponent() {
        return this.myStack.size() > 0 ? this.myStack.peek().getContent() : null;
    }

    public boolean dispatch(AWTEvent event) {
        if (event instanceof KeyEvent) {
            return this.dispatchKeyEvent((KeyEvent)event);
        }
        if (event instanceof MouseEvent) {
            return this.dispatchMouseEvent(event);
        }
        return false;
    }

    public void requestFocus() {
        if (this.myStack.isEmpty()) {
            return;
        }
        AbstractPopup popup = (AbstractPopup)this.myStack.peek();
        popup.requestFocus();
    }

    public boolean close() {
        return this.closeActivePopup();
    }

    public boolean closeActivePopup() {
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup = (AbstractPopup)this.myStack.pop();
        if (popup != null && popup.isVisible()) {
            popup.cancel();
            return true;
        }
        return false;
    }

    public boolean isPopupFocused() {
        return this.getFocusedPopup() != null;
    }

    private JBPopup getFocusedPopup() {
        for (JBPopup each : this.myAllPopups) {
            if (each == null || !each.isFocused()) continue;
            return each;
        }
        return null;
    }
}

