/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementFactory;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagNameReference
implements PsiReference {
    protected final boolean myStartTagFlag;
    private final ASTNode myNameElement;

    public TagNameReference(ASTNode nameElement, boolean startTagFlag) {
        this.myStartTagFlag = startTagFlag;
        this.myNameElement = nameElement;
    }

    public PsiElement getElement() {
        PsiElement element = this.myNameElement.getPsi();
        PsiElement parent = element.getParent();
        return parent instanceof XmlTag ? parent : element;
    }

    @Nullable
    protected XmlTag getTagElement() {
        PsiElement element = this.getElement();
        if (element == this.myNameElement.getPsi()) {
            return null;
        }
        return (XmlTag)element;
    }

    public TextRange getRangeInElement() {
        ASTNode nameElement = this.getNameElement();
        if (nameElement == null) {
            return new TextRange(0, 0);
        }
        if (this.myStartTagFlag) {
            int parentOffset = ((TreeElement)nameElement).getStartOffsetInParent();
            return new TextRange(parentOffset, parentOffset + nameElement.getTextLength());
        }
        PsiElement element = this.getElement();
        if (element == this.myNameElement) {
            return new TextRange(0, this.myNameElement.getTextLength());
        }
        int elementLength = element.getTextLength();
        int diffFromEnd = 0;
        for (ASTNode node = element.getNode().getLastChildNode(); node != nameElement && node != null; node = node.getTreePrev()) {
            diffFromEnd += node.getTextLength();
        }
        int nameEnd = elementLength - diffFromEnd;
        return new TextRange(nameEnd - nameElement.getTextLength(), nameEnd);
    }

    private ASTNode getNameElement() {
        return this.myNameElement;
    }

    public PsiElement resolve() {
        XmlElementDescriptor descriptor;
        XmlTag tag = this.getTagElement();
        XmlElementDescriptor xmlElementDescriptor = descriptor = tag != null ? tag.getDescriptor() : null;
        if (descriptor != null) {
            return descriptor instanceof AnyXmlElementDescriptor ? tag : descriptor.getDeclaration();
        }
        return null;
    }

    public String getCanonicalText() {
        return this.getNameElement().getText();
    }

    @Nullable
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        XmlTag element = this.getTagElement();
        if (element == null || !this.myStartTagFlag) {
            return element;
        }
        if (newElementName.indexOf(58) == -1) {
            PsiElement psiElement;
            String namespacePrefix = element.getNamespacePrefix();
            int index = newElementName.lastIndexOf(46);
            if (index != -1 && ((psiElement = this.resolve()) instanceof PsiFile || psiElement != null && psiElement.isEquivalentTo((PsiElement)psiElement.getContainingFile()))) {
                newElementName = newElementName.substring(0, index);
            }
            newElementName = TagNameReference.prependNamespacePrefix(newElementName, namespacePrefix);
        }
        element.setName(newElementName);
        return element;
    }

    private static String prependNamespacePrefix(String newElementName, String namespacePrefix) {
        newElementName = (namespacePrefix.length() > 0 ? namespacePrefix + ":" : namespacePrefix) + newElementName;
        return newElementName;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/TagNameReference.bindToElement must not be null");
        }
        PsiMetaData metaData = null;
        if (element instanceof PsiMetaOwner) {
            PsiMetaOwner owner = (PsiMetaOwner)element;
            metaData = owner.getMetaData();
            if (metaData instanceof XmlElementDescriptor) {
                return this.getTagElement().setName(metaData.getName(this.getElement()));
            }
        } else if (element instanceof PsiFile) {
            XmlTag tagElement = this.getTagElement();
            if (tagElement == null || !this.myStartTagFlag) {
                return tagElement;
            }
            String newElementName = ((PsiFile)element).getName();
            int index = newElementName.lastIndexOf(46);
            newElementName = TagNameReference.prependNamespacePrefix(newElementName.substring(0, index), tagElement.getNamespacePrefix());
            return this.getTagElement().setName(newElementName);
        }
        throw new IncorrectOperationException("Cant bind to not a xml element definition!" + element + "," + metaData);
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(element, this.resolve());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        PsiElement element = this.getElement();
        if (!this.myStartTagFlag) {
            if (element instanceof XmlTag) {
                objectArray = new LookupElement[]{TagNameReference.createClosingTagLookupElement((XmlTag)element)};
                if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/TagNameReference.getVariants must not return null");
                return objectArray;
            } else {
                objectArray = ArrayUtil.EMPTY_STRING_ARRAY;
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/TagNameReference.getVariants must not return null");
                return objectArray;
            }
        }
        objectArray = TagNameReference.getTagNameVariants((XmlTag)element);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/TagNameReference.getVariants must not return null");
    }

    protected static LookupElement createClosingTagLookupElement(XmlTag tag) {
        return TailTypeDecorator.withTail(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)LookupElementBuilder.create((String)tag.getName())), TailType.createSimpleTailType((char)'>'));
    }

    public static LookupElement[] getTagNameVariants(XmlTag element) {
        ArrayList<String> namespaces = new ArrayList<String>(Arrays.asList(element.knownNamespaces()));
        namespaces.add("");
        Object[] variants = TagNameReference.getTagNameVariants(element, namespaces, null);
        return (LookupElement[])ContainerUtil.map2Array((Object[])variants, MutableLookupElement.class, (Function)new Function<String, MutableLookupElement>(){

            public MutableLookupElement fun(String qname) {
                MutableLookupElement lookupElement = LookupElementFactory.getInstance().createLookupElement(qname);
                int separator = qname.indexOf(58);
                if (separator > 0) {
                    lookupElement.addLookupStrings(new String[]{qname.substring(separator + 1)});
                }
                lookupElement.setInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
                return lookupElement;
            }
        });
    }

    public static String[] getTagNameVariants(final XmlTag element, Collection<String> namespaces, @Nullable List<String> nsInfo) {
        XmlElementDescriptor elementDescriptor = null;
        String elementNamespace = null;
        HashMap<String, XmlElementDescriptor> descriptorsMap = new HashMap<String, XmlElementDescriptor>();
        PsiElement context = element.getParent();
        PsiElement curElement = element.getParent();
        while (curElement instanceof XmlTag) {
            XmlElementDescriptor descriptor;
            XmlTag declarationTag = (XmlTag)curElement;
            String namespace = declarationTag.getNamespace();
            if (!descriptorsMap.containsKey(namespace) && (descriptor = declarationTag.getDescriptor()) != null) {
                descriptorsMap.put(namespace, descriptor);
                if (elementDescriptor == null) {
                    elementDescriptor = descriptor;
                    elementNamespace = namespace;
                }
            }
            curElement = curElement.getContext();
        }
        HashSet<XmlNSDescriptor> visited = new HashSet<XmlNSDescriptor>();
        XmlExtension extension = XmlExtension.getExtension(element.getContainingFile());
        ArrayList<XmlElementDescriptor> variants = new ArrayList<XmlElementDescriptor>();
        for (String namespace : namespaces) {
            int initialSize = variants.size();
            TagNameReference.processVariantsInNamespace(namespace, element, variants, elementDescriptor, elementNamespace, descriptorsMap, visited, context instanceof XmlTag ? (XmlTag)context : element, extension);
            if (nsInfo == null) continue;
            for (int i = initialSize; i < variants.size(); ++i) {
                nsInfo.add(namespace);
            }
        }
        List l = ContainerUtil.mapNotNull(variants, (Function)new NullableFunction<XmlElementDescriptor, String>(){

            public String fun(XmlElementDescriptor descriptor) {
                return descriptor instanceof AnyXmlElementDescriptor ? null : descriptor.getName((PsiElement)element);
            }
        });
        return ArrayUtil.toStringArray((Collection)l);
    }

    private static void processVariantsInNamespace(String namespace, XmlTag element, List<XmlElementDescriptor> variants, XmlElementDescriptor elementDescriptor, String elementNamespace, Map<String, XmlElementDescriptor> descriptorsMap, Set<XmlNSDescriptor> visited, XmlTag parent, XmlExtension extension) {
        if (descriptorsMap.containsKey(namespace)) {
            XmlElementDescriptor descriptor = descriptorsMap.get(namespace);
            if (TagNameReference.isAcceptableNs(element, elementDescriptor, elementNamespace, namespace)) {
                for (XmlElementDescriptor containedDescriptor : descriptor.getElementsDescriptors(parent)) {
                    if (containedDescriptor == null) continue;
                    variants.add(containedDescriptor);
                }
            }
            if (element instanceof HtmlTag) {
                HtmlUtil.addHtmlSpecificCompletions(descriptor, element, variants);
            }
            visited.add(descriptor.getNSDescriptor());
        } else {
            if (namespace == null) {
                return;
            }
            if (namespace.length() == 0 && !visited.isEmpty()) {
                return;
            }
            XmlNSDescriptor nsDescriptor = TagNameReference.getDescriptor(element, namespace, true, extension);
            if (nsDescriptor == null) {
                if (!descriptorsMap.isEmpty()) {
                    return;
                }
                nsDescriptor = TagNameReference.getDescriptor(element, namespace, false, extension);
            }
            if (nsDescriptor != null && !visited.contains(nsDescriptor) && TagNameReference.isAcceptableNs(element, elementDescriptor, elementNamespace, namespace)) {
                XmlElementDescriptor parentDescriptor;
                visited.add(nsDescriptor);
                XmlElementDescriptor[] rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class));
                XmlTag parentTag = extension.getParentTagForNamespace(element, nsDescriptor);
                if (parentTag == element.getParentTag()) {
                    parentDescriptor = elementDescriptor;
                } else {
                    assert (parentTag != null);
                    parentDescriptor = parentTag.getDescriptor();
                }
                for (XmlElementDescriptor candidateDescriptor : rootElementsDescriptors) {
                    if (candidateDescriptor == null || !TagNameReference.couldContainDescriptor(parentTag, parentDescriptor, candidateDescriptor, namespace)) continue;
                    variants.add(candidateDescriptor);
                }
            }
        }
    }

    private static XmlNSDescriptor getDescriptor(XmlTag element, String namespace, boolean strict, XmlExtension extension) {
        return extension.getNSDescriptor(element, namespace, strict);
    }

    private static boolean couldContainDescriptor(XmlTag parentTag, XmlElementDescriptor parentDescriptor, XmlElementDescriptor childDescriptor, String childNamespace) {
        if (XmlUtil.nsFromTemplateFramework(childNamespace)) {
            return true;
        }
        if (parentTag == null) {
            return true;
        }
        XmlTag childTag = parentTag.createChildTag(childDescriptor.getName(), childNamespace, "", false);
        childTag.putUserData(XmlElement.INCLUDING_ELEMENT, (Object)parentTag);
        return parentDescriptor != null && parentDescriptor.getElementDescriptor(childTag, parentTag) != null;
    }

    private static boolean isAcceptableNs(XmlTag element, XmlElementDescriptor elementDescriptor, String elementNamespace, String namespace) {
        return !(elementDescriptor instanceof XmlElementDescriptorAwareAboutChildren) || elementNamespace == null || elementNamespace.equals(namespace) || ((XmlElementDescriptorAwareAboutChildren)elementDescriptor).allowElementsFromNamespace(namespace, element.getParentTag());
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    public static TagNameReference create(XmlElement element, ASTNode nameElement, boolean startTagFlag) {
        XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)element);
        return extension == null ? null : extension.createTagNameReference(nameElement, startTagFlag);
    }
}

