/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;

public class XmlAttributeValueManipulator
extends AbstractElementManipulator<XmlAttributeValue> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.manipulators.XmlAttributeValueManipulator");

    public XmlAttributeValue handleContentChange(XmlAttributeValue element, TextRange range, String newContent) throws IncorrectOperationException {
        String text;
        CheckUtil.checkWritable((PsiElement)element);
        CompositeElement attrNode = (CompositeElement)element.getNode();
        LeafElement valueNode = attrNode.findLeafElementAt(range.getStartOffset());
        PsiElement elementToReplace = valueNode.getPsi();
        try {
            text = elementToReplace.getText();
            int offsetInParent = elementToReplace.getStartOffsetInParent();
            String textBeforeRange = text.substring(0, range.getStartOffset() - offsetInParent);
            String textAfterRange = text.substring(range.getEndOffset() - offsetInParent, text.length());
            text = textBeforeRange + newContent + textAfterRange;
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Range: " + range + " in text: '" + element.getText() + "'", (Throwable)e);
            throw e;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(attrNode);
        LeafElement newValueElement = Factory.createSingleLeafElement(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, text, charTableByTree, element.getManager());
        attrNode.replaceChildInternal(valueNode, newValueElement);
        return element;
    }

    public TextRange getRangeInElement(XmlAttributeValue xmlAttributeValue) {
        PsiElement child = xmlAttributeValue.getFirstChild();
        if (child == null) {
            return new TextRange(0, 0);
        }
        ASTNode node = child.getNode();
        assert (node != null);
        int textLength = xmlAttributeValue.getTextLength();
        if (node.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return new TextRange(1, textLength <= 1 ? 1 : textLength - 1);
        }
        return new TextRange(0, textLength);
    }
}

