/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.Language;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiCodeFragmentImpl
extends PsiFileImpl
implements JavaCodeFragment {
    private PsiElement myContext;
    private boolean myPhysical;
    private PsiType myThisType;
    private PsiType mySuperType;
    private LinkedHashMap<String, String> myPseudoImports = new LinkedHashMap();
    private JavaCodeFragment.VisibilityChecker myVisibilityChecker;
    private JavaCodeFragment.ExceptionHandler myExceptionHandler;
    private GlobalSearchScope myResolveScope;
    private IntentionFilterOwner.IntentionActionsFilter myIntentionActionsFilter;
    private FileViewProvider myViewProvider = null;

    public PsiCodeFragmentImpl(Project project, IElementType contentElementType, boolean isPhysical, @NonNls String name, CharSequence text) {
        super(Constants.CODE_FRAGMENT, contentElementType, ((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile(name, FileTypeManager.getInstance().getFileTypeByFileName(name), text), isPhysical));
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi(this);
        this.myPhysical = isPhysical;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getContentElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiCodeFragmentImpl.getLanguage must not return null");
        }
        return language;
    }

    @Override
    protected PsiCodeFragmentImpl clone() {
        PsiCodeFragmentImpl clone = (PsiCodeFragmentImpl)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myPhysical = false;
        clone.myOriginalFile = this;
        clone.myPseudoImports = new LinkedHashMap<String, String>(this.myPseudoImports);
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi(clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider;
        if (this.myViewProvider != null) {
            fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiCodeFragmentImpl.getViewProvider must not return null");
            return fileViewProvider;
        }
        fileViewProvider = super.getViewProvider();
        if (fileViewProvider != null) return fileViewProvider;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiCodeFragmentImpl.getViewProvider must not return null");
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.myContext == null || this.myContext.isValid();
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiCodeFragmentImpl.getFileType must not return null");
        }
        return languageFileType;
    }

    @Override
    public PsiElement getContext() {
        return this.myContext;
    }

    public void setContext(PsiElement context) {
        this.myContext = context;
    }

    public PsiType getThisType() {
        return this.myThisType;
    }

    public void setThisType(PsiType psiType) {
        this.myThisType = psiType;
    }

    public PsiType getSuperType() {
        return this.mySuperType;
    }

    public void setSuperType(PsiType superType) {
        this.mySuperType = superType;
    }

    public String importsToString() {
        return StringUtil.join(this.myPseudoImports.values(), (String)",");
    }

    public void addImportsFromString(String imports) {
        StringTokenizer tokenizer = new StringTokenizer(imports, ",");
        while (tokenizer.hasMoreTokens()) {
            String qName = tokenizer.nextToken();
            String name = PsiNameHelper.getShortClassName((String)qName);
            this.myPseudoImports.put(name, qName);
        }
    }

    public void setVisibilityChecker(JavaCodeFragment.VisibilityChecker checker) {
        this.myVisibilityChecker = checker;
    }

    public JavaCodeFragment.VisibilityChecker getVisibilityChecker() {
        return this.myVisibilityChecker;
    }

    @Override
    public boolean isPhysical() {
        return this.myPhysical;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiCodeFragmentImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitCodeFragment((JavaCodeFragment)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        IElementType i;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiCodeFragmentImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiCodeFragmentImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiCodeFragmentImpl.processDeclarations must not be null");
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) {
            String name;
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String string = name = nameHint != null ? nameHint.getName(state) : null;
            if (name != null) {
                PsiClass imported;
                String qNameImported = this.myPseudoImports.get(name);
                if (qNameImported != null && (imported = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qNameImported, this.getResolveScope())) != null && !processor.execute((PsiElement)imported, state)) {
                    return false;
                }
            } else {
                for (String qNameImported : this.myPseudoImports.values()) {
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qNameImported, this.getResolveScope());
                    if (aClass == null || processor.execute((PsiElement)aClass, state)) continue;
                    return false;
                }
            }
            if (this.myContext == null) {
                return JavaResolveUtil.processImplicitlyImportedPackages(processor, state, place, this.getManager());
            }
        }
        if ((i = this.myContentElementType) == ElementType.TYPE_TEXT || i == ElementType.EXPRESSION_STATEMENT || i == ElementType.REFERENCE_TEXT) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor, state, lastParent, place);
    }

    public String toString() {
        return "PsiCodeFragment:" + this.getName();
    }

    public boolean importClass(PsiClass aClass) {
        String className = aClass.getName();
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        this.myPseudoImports.put(className, qName);
        this.myManager.nonPhysicalChange();
        if (this.isPhysical()) {
            Project project = this.myManager.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)this);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new ImportClassUndoableAction(className, qName, document, this.myPseudoImports));
        }
        return true;
    }

    public JavaCodeFragment.ExceptionHandler getExceptionHandler() {
        return this.myExceptionHandler;
    }

    public void setIntentionActionsFilter(IntentionFilterOwner.IntentionActionsFilter filter) {
        this.myIntentionActionsFilter = filter;
    }

    public IntentionFilterOwner.IntentionActionsFilter getIntentionActionsFilter() {
        return this.myIntentionActionsFilter;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope;
        if (this.myResolveScope != null) {
            globalSearchScope = this.myResolveScope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiCodeFragmentImpl.getResolveScope must not return null");
            return globalSearchScope;
        }
        globalSearchScope = super.getResolveScope();
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiCodeFragmentImpl.getResolveScope must not return null");
    }

    public void setExceptionHandler(JavaCodeFragment.ExceptionHandler exceptionHandler) {
        this.myExceptionHandler = exceptionHandler;
    }

    private static class ImportClassUndoableAction
    implements UndoableAction {
        private final String myClassName;
        private final String myQName;
        private final LinkedHashMap<String, String> myPseudoImports;
        private final DocumentReference[] myReferences;

        public ImportClassUndoableAction(String className, String qName, Document document, LinkedHashMap<String, String> pseudoImportsMap) {
            this.myClassName = className;
            this.myQName = qName;
            this.myPseudoImports = pseudoImportsMap;
            this.myReferences = new DocumentReference[]{DocumentReferenceManager.getInstance().create(document)};
        }

        public boolean isGlobal() {
            return false;
        }

        public void undo() {
            this.myPseudoImports.remove(this.myClassName);
        }

        public void redo() {
            this.myPseudoImports.put(this.myClassName, this.myQName);
        }

        public DocumentReference[] getAffectedDocuments() {
            return this.myReferences;
        }
    }
}

