/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.JavaFileStubBuilder;
import com.intellij.psi.impl.source.parsing.FileTextParsing;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;

public class JavaFileElementType
extends IStubFileElementType<PsiJavaFileStub> {
    public static final int STUB_VERSION = 3;

    public JavaFileElementType() {
        super("java.FILE", StdLanguages.JAVA);
    }

    public StubBuilder getBuilder() {
        return new JavaFileStubBuilder();
    }

    public int getStubVersion() {
        return 3;
    }

    public boolean shouldBuildStubFor(VirtualFile file) {
        VirtualFile dir = file.getParent();
        return dir == null || dir.getUserData(LanguageLevel.KEY) != null;
    }

    public ASTNode parseContents(ASTNode chameleon) {
        FileElement node = (FileElement)chameleon;
        CharSequence seq = node.getChars();
        PsiManagerEx manager = node.getManager();
        JavaLexer lexer = new JavaLexer(PsiUtil.getLanguageLevel((PsiElement)node.getPsi()));
        return FileTextParsing.parseFileText(manager, (Lexer)lexer, seq, 0, seq.length(), node.getCharTable());
    }

    public String getExternalId() {
        return "java.FILE";
    }

    public void serialize(PsiJavaFileStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeBoolean(stub.isCompiled());
        dataStream.writeName(stub.getPackageName());
    }

    public PsiJavaFileStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        boolean compiled = dataStream.readBoolean();
        StringRef packName = dataStream.readName();
        return new PsiJavaFileStubImpl(packName, compiled);
    }

    public void indexStub(PsiJavaFileStub stub, IndexSink sink) {
    }
}

