/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClsParameterImpl
extends ClsRepositoryPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsParameterImpl");
    private volatile PsiTypeElement myType;
    private String myMirrorName = null;
    private String myName = null;
    public static final ClsParameterImpl[] EMPTY_ARRAY = new ClsParameterImpl[0];

    public ClsParameterImpl(PsiParameterStub stub) {
        super(stub);
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public String getName() {
        if (this.myName == null) {
            if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
                return null;
            }
            ClsMethodImpl method = (ClsMethodImpl)this.getDeclarationScope();
            PsiMethod sourceMethod = (PsiMethod)method.getNavigationElement();
            if (sourceMethod == method) {
                PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
                if (!parameterStub.isAutoGeneratedName()) {
                    return parameterStub.getName();
                }
                return null;
            }
            this.myName = sourceMethod.getParameterList().getParameters()[this.getIndex()].getName();
        }
        return this.myName;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PsiTypeElement getTypeElement() {
        if (this.myType == null) {
            Object object = LAZY_BUILT_LOCK;
            synchronized (object) {
                if (this.myType == null) {
                    this.myType = new ClsTypeElementImpl(this, TypeInfo.createTypeText(((PsiParameterStub)this.getStub()).getType(false)), '\u0000');
                }
            }
        }
        PsiTypeElement psiTypeElement = this.myType;
        if (psiTypeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getTypeElement must not return null");
        }
        return psiTypeElement;
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeElement().getType();
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getType must not return null");
        }
        return psiType;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        StubElement child = ((PsiParameterStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST);
        assert (child != null);
        PsiModifierList psiModifierList = (PsiModifierList)child.getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = this.getModifierList().getAnnotations()) {
            ((ClsAnnotationImpl)annotation).appendMirrorText(indentLevel, buffer);
            buffer.append(" ");
        }
        ((ClsElementImpl)this.getTypeElement()).appendMirrorText(indentLevel, buffer);
        buffer.append(" ");
        buffer.append(this.getMirrorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMirrorName() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myMirrorName == null) {
                PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
                if (!parameterStub.isAutoGeneratedName()) {
                    this.myMirrorName = parameterStub.getName();
                    return this.myMirrorName;
                }
                PsiParameter[] parms = ((PsiParameterList)this.getParent()).getParameters();
                if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
                    return "p" + Arrays.asList(parms).indexOf((Object)this);
                }
                String name = this.getName();
                if (name != null) {
                    return name;
                }
                String[] nameSuggestions = JavaCodeStyleManager.getInstance((Project)this.getProject()).suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)this.getType()).names;
                name = "p";
                if (nameSuggestions.length > 0) {
                    name = nameSuggestions[0];
                }
                block3: while (true) {
                    PsiParameter[] arr$ = parms;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block3;
                        PsiParameter parm = arr$[i$];
                        if (parm == this) break block3;
                        String name1 = ((ClsParameterImpl)parm).getMirrorName();
                        if (name.equals(name1)) {
                            name = ClsParameterImpl.nextName(name);
                            continue block3;
                        }
                        ++i$;
                    }
                    break;
                }
                this.myMirrorName = name;
            }
            return this.myMirrorName;
        }
    }

    private static String nextName(String name) {
        char c;
        int count;
        for (count = 0; count != name.length() && '0' <= (c = name.charAt(name.length() - count - 1)) && c <= '9'; ++count) {
        }
        try {
            int n = count > 0 ? Integer.parseInt(name.substring(name.length() - count)) : 0;
            return name.substring(0, name.length() - count) + ++n;
        }
        catch (NumberFormatException e) {
            LOG.assertTrue(false);
            return null;
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiParameter mirror = (PsiParameter)SourceTreeToPsiMap.treeElementToPsi(element);
        ((ClsElementImpl)this.getModifierList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getModifierList()));
        ((ClsElementImpl)this.getTypeElement()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getTypeElement()));
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameter((PsiParameter)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiParameter";
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.getParent().getParent();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getDeclarationScope must not return null");
        }
        return psiElement;
    }

    private int getIndex() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        return stub.getParentStub().getChildrenStubs().indexOf(stub);
    }

    public boolean isVarArgs() {
        PsiParameterList paramList = (PsiParameterList)this.getParent();
        PsiMethod method = (PsiMethod)paramList.getParent();
        return method.isVarArgs() && this.getIndex() == paramList.getParametersCount() - 1;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getModifierList().getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ClsParameterImpl.createLayeredIcon((Icon)Icons.PARAMETER_ICON, (int)0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope(this.getDeclarationScope());
        if (localSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getUseScope must not return null");
        }
        return localSearchScope;
    }

    public PsiType getTypeNoResolve() {
        return this.getType();
    }
}

