/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.id.FileTypeIdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IdDataConsumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class LexerBasedIdIndexer
extends FileTypeIdIndexer {
    @Override
    @NotNull
    public final Map<IdIndexEntry, Integer> map(FileContent inputData) {
        IdDataConsumer consumer = new IdDataConsumer();
        Lexer lexer = this.createLexer(new OccurrenceToIdDataConsumerAdapter(consumer));
        CharSequence chars = inputData.getContentAsText();
        lexer.start(chars);
        while (lexer.getTokenType() != null) {
            lexer.advance();
        }
        Map<IdIndexEntry, Integer> map = consumer.getResult();
        if (map == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/id/LexerBasedIdIndexer.map must not return null");
        }
        return map;
    }

    protected abstract Lexer createLexer(BaseFilterLexer.OccurrenceConsumer var1);

    private static class OccurrenceToIdDataConsumerAdapter
    implements BaseFilterLexer.OccurrenceConsumer {
        private final IdDataConsumer myIndexDataConsumer;

        public OccurrenceToIdDataConsumerAdapter(IdDataConsumer indexDataConsumer) {
            this.myIndexDataConsumer = indexDataConsumer;
        }

        @Override
        public void addOccurrence(CharSequence charSequence, int start, int end, int occurrenceMask) {
            this.myIndexDataConsumer.addOccurrence(charSequence, start, end, occurrenceMask);
        }

        @Override
        public void incTodoOccurrence(IndexPattern pattern) {
        }

        @Override
        public boolean canConsumeTodoOccurrences() {
            return false;
        }
    }
}

