/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.CommitToPsiFileAction;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.TextBlock;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.util.messages.MessageBus;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class PsiToDocumentSynchronizer
extends PsiTreeChangeAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiToDocumentSynchronizer");
    private final PsiDocumentManagerImpl myPsiDocumentManager;
    private final MessageBus myBus;
    private final Map<Document, Pair<DocumentChangeTransaction, Integer>> myTransactionsMap = new HashMap<Document, Pair<DocumentChangeTransaction, Integer>>();
    private volatile Document mySyncDocument = null;

    public PsiToDocumentSynchronizer(PsiDocumentManagerImpl psiDocumentManager, MessageBus bus) {
        this.myPsiDocumentManager = psiDocumentManager;
        this.myBus = bus;
    }

    @Nullable
    public DocumentChangeTransaction getTransaction(Document document) {
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(document);
        return pair != null ? (DocumentChangeTransaction)pair.getFirst() : null;
    }

    public boolean isInSynchronization(Document document) {
        return this.mySyncDocument == document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSync(PsiTreeChangeEvent event, DocSyncAction syncAction) {
        if (!PsiToDocumentSynchronizer.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (psiFile == null || psiFile.getNode() == null) {
            return;
        }
        DocumentEx document = this.getCachedDocument(psiFile);
        if (document == null || document instanceof DocumentWindow) {
            return;
        }
        TextBlock textBlock = this.getTextBlock(document, psiFile);
        if (!textBlock.isEmpty()) {
            LOG.error("Attempt to modify PSI for non-committed Document!");
            textBlock.clear();
        }
        textBlock.lock();
        try {
            syncAction.syncDocument(document, (PsiTreeChangeEventImpl)event);
        }
        finally {
            textBlock.unlock();
        }
        this.myPsiDocumentManager.commitOtherFilesAssociatedWithDocument(document, psiFile);
        boolean insideTransaction = this.myTransactionsMap.containsKey(document);
        if (!insideTransaction) {
            document.setModificationStamp(psiFile.getModificationStamp());
            SmartPointerManagerImpl.synchronizePointers(psiFile);
            if (LOG.isDebugEnabled()) {
                PsiDocumentManagerImpl.checkConsistency(psiFile, document);
            }
        }
    }

    public void childAdded(PsiTreeChangeEvent event) {
        this.doSync(event, new DocSyncAction(){

            @Override
            public void syncDocument(Document document, PsiTreeChangeEventImpl event) {
                PsiToDocumentSynchronizer.this.insertString(document, event.getOffset(), event.getChild().getText());
            }
        });
    }

    public void childRemoved(PsiTreeChangeEvent event) {
        this.doSync(event, new DocSyncAction(){

            @Override
            public void syncDocument(Document document, PsiTreeChangeEventImpl event) {
                PsiToDocumentSynchronizer.this.deleteString(document, event.getOffset(), event.getOffset() + event.getOldLength());
            }
        });
    }

    public void childReplaced(PsiTreeChangeEvent event) {
        this.doSync(event, new DocSyncAction(){

            @Override
            public void syncDocument(Document document, PsiTreeChangeEventImpl event) {
                PsiToDocumentSynchronizer.this.replaceString(document, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewChild().getText());
            }
        });
    }

    public void childrenChanged(PsiTreeChangeEvent event) {
        this.doSync(event, new DocSyncAction(){

            @Override
            public void syncDocument(Document document, PsiTreeChangeEventImpl event) {
                PsiToDocumentSynchronizer.this.replaceString(document, event.getOffset(), event.getOffset() + event.getOldLength(), event.getParent().getText());
            }
        });
    }

    private static boolean toProcessPsiEvent() {
        Application application = ApplicationManager.getApplication();
        return application.getCurrentWriteAction(CommitToPsiFileAction.class) == null && application.getCurrentWriteAction(ExternalChangeAction.class) == null;
    }

    public void replaceString(Document document, int startOffset, int endOffset, String s) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, s);
        }
    }

    public void insertString(Document document, int offset, String s) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(offset, 0, s);
        }
    }

    private void deleteString(Document document, int startOffset, int endOffset) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, "");
        }
    }

    @Nullable
    private DocumentEx getCachedDocument(PsiFile file) {
        return (DocumentEx)this.myPsiDocumentManager.getCachedDocument(file);
    }

    private TextBlock getTextBlock(Document document, PsiFile file) {
        return this.myPsiDocumentManager.getTextBlock(document, file);
    }

    public void startTransaction(Document doc, PsiElement scope) {
        Pair pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            PsiFile psiFile = scope != null ? scope.getContainingFile() : null;
            pair = new Pair((Object)new DocumentChangeTransaction(doc, (PsiFile)(scope != null ? psiFile : null)), (Object)0);
            ((PsiDocumentTransactionListener)this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC)).transactionStarted(doc, psiFile);
        } else {
            pair = new Pair(pair.getFirst(), (Object)((Integer)pair.getSecond() + 1));
        }
        this.myTransactionsMap.put(doc, (Pair<DocumentChangeTransaction, Integer>)pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(Document document) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final DocumentChangeTransaction documentChangeTransaction = this.removeTransaction(document);
        if (documentChangeTransaction == null) {
            return;
        }
        PsiFile changeScope = documentChangeTransaction.getChangeScope();
        try {
            this.mySyncDocument = document;
            PsiTreeChangeEventImpl fakeEvent = new PsiTreeChangeEventImpl(changeScope.getManager());
            fakeEvent.setParent((PsiElement)changeScope);
            fakeEvent.setFile(changeScope.getContainingFile());
            this.doSync(fakeEvent, new DocSyncAction(){

                @Override
                public void syncDocument(Document document, PsiTreeChangeEventImpl event) {
                    PsiToDocumentSynchronizer.doCommitTransaction(document, documentChangeTransaction);
                }
            });
            ((PsiDocumentTransactionListener)this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC)).transactionCompleted(document, changeScope);
        }
        finally {
            this.mySyncDocument = null;
        }
    }

    public void doCommitTransaction(Document document) {
        PsiToDocumentSynchronizer.doCommitTransaction(document, this.getTransaction(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCommitTransaction(Document document, DocumentChangeTransaction documentChangeTransaction) {
        DocumentEx ex = (DocumentEx)document;
        ex.suppressGuardedExceptions();
        try {
            boolean isReadOnly = !document.isWritable();
            ex.setReadOnly(false);
            Set<Pair<MutableTextRange, StringBuffer>> affectedFragments = documentChangeTransaction.getAffectedFragments();
            for (Pair<MutableTextRange, StringBuffer> pair : affectedFragments) {
                StringBuffer replaceBuffer = (StringBuffer)pair.getSecond();
                MutableTextRange range = (MutableTextRange)pair.getFirst();
                if (replaceBuffer.length() == 0) {
                    ex.deleteString(range.getStartOffset(), range.getEndOffset());
                    continue;
                }
                if (range.getLength() == 0) {
                    ex.insertString(range.getStartOffset(), replaceBuffer);
                    continue;
                }
                ex.replaceString(range.getStartOffset(), range.getEndOffset(), replaceBuffer);
            }
            ex.setReadOnly(isReadOnly);
        }
        finally {
            ex.unSuppressGuardedExceptions();
        }
    }

    @Nullable
    private DocumentChangeTransaction removeTransaction(Document doc) {
        Pair pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            return null;
        }
        if ((Integer)pair.getSecond() > 0) {
            pair = new Pair(pair.getFirst(), (Object)((Integer)pair.getSecond() - 1));
            this.myTransactionsMap.put(doc, (Pair<DocumentChangeTransaction, Integer>)pair);
            return null;
        }
        this.myTransactionsMap.remove(doc);
        return (DocumentChangeTransaction)pair.getFirst();
    }

    public boolean isDocumentAffectedByTransactions(Document document) {
        return this.myTransactionsMap.containsKey(document);
    }

    public static class MutableTextRange {
        private final int myLength;
        private int myStartOffset;

        public MutableTextRange(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myLength = endOffset - startOffset;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myStartOffset + this.myLength;
        }

        public int getLength() {
            return this.myLength;
        }

        public String toString() {
            return "[" + this.getStartOffset() + ", " + this.getEndOffset() + "]";
        }

        public void shift(int lengthDiff) {
            this.myStartOffset += lengthDiff;
        }
    }

    public static class DocumentChangeTransaction {
        private final Set<Pair<MutableTextRange, StringBuffer>> myAffectedFragments = new TreeSet<Pair<MutableTextRange, StringBuffer>>(new Comparator<Pair<MutableTextRange, StringBuffer>>(){

            @Override
            public int compare(Pair<MutableTextRange, StringBuffer> o1, Pair<MutableTextRange, StringBuffer> o2) {
                return ((MutableTextRange)o1.getFirst()).getStartOffset() - ((MutableTextRange)o2.getFirst()).getStartOffset();
            }
        });
        private final Document myDocument;
        private final PsiFile myChangeScope;

        public DocumentChangeTransaction(Document doc, PsiFile scope) {
            this.myDocument = doc;
            this.myChangeScope = scope;
        }

        public Set<Pair<MutableTextRange, StringBuffer>> getAffectedFragments() {
            return this.myAffectedFragments;
        }

        public PsiFile getChangeScope() {
            return this.myChangeScope;
        }

        public void replace(int start, int length, String str) {
            int newStartInString;
            int oldStart = start;
            int end = start + length;
            int newStringLength = str.length();
            String chars = this.getText(start, end);
            if (chars.equals(str)) {
                return;
            }
            int newEndInString = newStringLength;
            for (newStartInString = 0; newStartInString < newStringLength && start < end && str.charAt(newStartInString) == chars.charAt(start - oldStart); ++start, ++newStartInString) {
            }
            while (end > start && newEndInString > newStartInString && str.charAt(newEndInString - 1) == chars.charAt(end - oldStart - 1)) {
                --newEndInString;
                --end;
            }
            CharSequence charsSequence = this.myDocument.getCharsSequence();
            while (start < charsSequence.length() && end < charsSequence.length() && start > 0 && ((Object)charsSequence.subSequence(start, end)).toString().endsWith("><") && charsSequence.charAt(start - 1) == '<') {
                --start;
                --newStartInString;
                --end;
                --newEndInString;
            }
            str = str.substring(newStartInString, newEndInString);
            length = end - start;
            Pair<MutableTextRange, StringBuffer> fragment = this.getFragmentByRange(start, length);
            StringBuffer fragmentReplaceText = (StringBuffer)fragment.getSecond();
            int startInFragment = start - ((MutableTextRange)fragment.getFirst()).getStartOffset();
            int lengthDiff = str.length() - length;
            Iterator<Pair<MutableTextRange, StringBuffer>> iterator = this.myAffectedFragments.iterator();
            boolean adjust = false;
            while (iterator.hasNext()) {
                Pair<MutableTextRange, StringBuffer> pair = iterator.next();
                if (adjust) {
                    ((MutableTextRange)pair.getFirst()).shift(lengthDiff);
                }
                if (pair != fragment) continue;
                adjust = true;
            }
            fragmentReplaceText.replace(startInFragment, startInFragment + length, str);
        }

        private String getText(int start, int end) {
            int currentOldDocumentOffset = 0;
            int currentNewDocumentOffset = 0;
            StringBuilder text = new StringBuilder();
            Iterator<Pair<MutableTextRange, StringBuffer>> iterator = this.myAffectedFragments.iterator();
            while (iterator.hasNext() && currentNewDocumentOffset < end) {
                Pair<MutableTextRange, StringBuffer> pair = iterator.next();
                MutableTextRange range = (MutableTextRange)pair.getFirst();
                StringBuffer buffer = (StringBuffer)pair.getSecond();
                int fragmentEndInNewDocument = range.getStartOffset() + buffer.length();
                if (range.getStartOffset() <= start && fragmentEndInNewDocument >= end) {
                    return buffer.substring(start - range.getStartOffset(), end - range.getStartOffset());
                }
                if (range.getStartOffset() >= start) {
                    int effectiveStart = Math.max(currentNewDocumentOffset, start);
                    text.append(this.myDocument.getCharsSequence(), effectiveStart - currentNewDocumentOffset + currentOldDocumentOffset, Math.min(range.getStartOffset(), end) - currentNewDocumentOffset + currentOldDocumentOffset);
                    if (end > range.getStartOffset()) {
                        text.append(buffer.substring(0, Math.min(end - range.getStartOffset(), buffer.length())));
                    }
                }
                currentOldDocumentOffset += range.getEndOffset() - currentNewDocumentOffset;
                currentNewDocumentOffset = fragmentEndInNewDocument;
            }
            if (currentNewDocumentOffset < end) {
                int effectiveStart = Math.max(currentNewDocumentOffset, start);
                text.append(this.myDocument.getCharsSequence(), effectiveStart - currentNewDocumentOffset + currentOldDocumentOffset, end - currentNewDocumentOffset + currentOldDocumentOffset);
            }
            return text.toString();
        }

        private Pair<MutableTextRange, StringBuffer> getFragmentByRange(int start, int length) {
            StringBuffer fragmentBuffer = new StringBuffer();
            int end = start + length;
            int documentOffset = 0;
            int effectiveOffset = 0;
            Iterator<Pair<MutableTextRange, StringBuffer>> iterator = this.myAffectedFragments.iterator();
            while (iterator.hasNext() && effectiveOffset <= end) {
                Pair<MutableTextRange, StringBuffer> pair = iterator.next();
                MutableTextRange range = (MutableTextRange)pair.getFirst();
                StringBuffer buffer = (StringBuffer)pair.getSecond();
                int effectiveFragmentEnd = range.getStartOffset() + buffer.length();
                if (range.getStartOffset() <= start && effectiveFragmentEnd >= end) {
                    return pair;
                }
                if (effectiveFragmentEnd >= start) {
                    int effectiveStart = Math.max(effectiveOffset, start);
                    if (range.getStartOffset() > start) {
                        fragmentBuffer.append(this.myDocument.getCharsSequence(), effectiveStart - effectiveOffset + documentOffset, Math.min(range.getStartOffset(), end) - effectiveOffset + documentOffset);
                    }
                    if (end >= range.getStartOffset()) {
                        fragmentBuffer.append(buffer);
                        end = end > effectiveFragmentEnd ? end - (buffer.length() - range.getLength()) : range.getEndOffset();
                        effectiveFragmentEnd = range.getEndOffset();
                        start = Math.min(start, range.getStartOffset());
                        iterator.remove();
                    }
                }
                documentOffset += range.getEndOffset() - effectiveOffset;
                effectiveOffset = effectiveFragmentEnd;
            }
            if (effectiveOffset < end) {
                int effectiveStart = Math.max(effectiveOffset, start);
                fragmentBuffer.append(this.myDocument.getCharsSequence(), effectiveStart - effectiveOffset + documentOffset, end - effectiveOffset + documentOffset);
            }
            MutableTextRange newRange = new MutableTextRange(start, end);
            Pair pair = new Pair((Object)newRange, (Object)fragmentBuffer);
            for (Pair<MutableTextRange, StringBuffer> affectedFragment : this.myAffectedFragments) {
                MutableTextRange range = (MutableTextRange)affectedFragment.getFirst();
                assert (end <= range.getStartOffset() || range.getEndOffset() <= start) : "Range :" + range + "; Added: " + newRange;
            }
            this.myAffectedFragments.add((Pair<MutableTextRange, StringBuffer>)pair);
            return pair;
        }
    }

    private static interface DocSyncAction {
        public void syncDocument(Document var1, PsiTreeChangeEventImpl var2);
    }
}

