/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.CommitToPsiFileAction;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.TextBlock;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocumentManagerImpl
extends PsiDocumentManager
implements ProjectComponent,
DocumentListener,
SettingsSavingComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiDocumentManagerImpl");
    private static final Key<PsiFile> HARD_REF_TO_PSI = new Key("HARD_REFERENCE_TO_PSI");
    private static final Key<Boolean> KEY_COMMITING = new Key("Commiting");
    private static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create((String)"ACTION_AFTER_COMMIT");
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final Key<TextBlock> KEY_TEXT_BLOCK = Key.create((String)"KEY_TEXT_BLOCK");
    private final Set<Document> myUncommittedDocuments = Collections.synchronizedSet(new HashSet());
    private final BlockSupportImpl myBlockSupport;
    private volatile boolean myIsCommitInProgress;
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners = new ArrayList<PsiDocumentManager.Listener>();
    private PsiDocumentManager.Listener[] myCachedListeners = null;
    private final SmartPointerManagerImpl mySmartPointerManager;
    private ASTNode myTreeElementBeingReparsedSoItWontBeCollected;
    private final Key<ASTNode> TEMP_TREE_IN_DOCUMENT_KEY = Key.create((String)"TEMP_TREE_IN_DOCUMENT_KEY");

    public PsiDocumentManagerImpl(Project project, PsiManager psiManager, SmartPointerManager smartPointerManager, BlockSupport blockSupport, EditorFactory editorFactory, MessageBus bus) {
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.mySmartPointerManager = (SmartPointerManagerImpl)smartPointerManager;
        this.myBlockSupport = (BlockSupportImpl)blockSupport;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.mySynchronizer);
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)this.myProject);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("PsiDocumentManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiDocumentManagerImpl.getComponentName must not return null");
        }
        return "PsiDocumentManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.getPsiFile must not be null");
        }
        PsiFile userData = (PsiFile)document.getUserData(HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile == null) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            psiFile = this.getPsiFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            this.fireFileCreated(document, psiFile);
        }
        return psiFile;
    }

    public static void cachePsi(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.cachePsi must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.cachePsi must not be null");
        }
        document.putUserData(HARD_REF_TO_PSI, (Object)file);
    }

    public PsiFile getCachedPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.getCachedPsiFile must not be null");
        }
        PsiFile userData = (PsiFile)document.getUserData(HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    public FileViewProvider getCachedViewProvider(Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findCachedViewProvider(virtualFile);
    }

    @Nullable
    protected PsiFile getCachedPsiFile(VirtualFile virtualFile) {
        return ((PsiManagerEx)this.myPsiManager).getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    protected PsiFile getPsiFile(VirtualFile virtualFile) {
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findFile(virtualFile);
    }

    public Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.getDocument must not be null");
        }
        if (file instanceof PsiBinaryFile) {
            return null;
        }
        Document document = this.getCachedDocument(file);
        if (document != null) {
            if (!file.getViewProvider().isPhysical() && document.getUserData(HARD_REF_TO_PSI) == null) {
                PsiDocumentManagerImpl.cachePsi(document, file);
            }
            return document;
        }
        if (!file.getViewProvider().isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(file.getViewProvider().getVirtualFile());
        if (!file.getViewProvider().isPhysical()) {
            PsiDocumentManagerImpl.cachePsi(document, file);
        }
        this.fireDocumentCreated(document, file);
        return document;
    }

    public Document getCachedDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.getCachedDocument must not be null");
        }
        if (!file.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    public void commitAllDocuments() {
        Document[] documents;
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            this.commitDocument(document);
        }
    }

    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document;
        if (doc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.performForCommittedDocument must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.performForCommittedDocument must not be null");
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isUncommited(document)) {
            this.addRunOnCommit(document, action);
        } else {
            action.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunOnCommit(Document document, Runnable action) {
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            List list = (List)document.getUserData(ACTION_AFTER_COMMIT);
            if (list == null) {
                list = new SmartList();
                document.putUserData(ACTION_AFTER_COMMIT, (Object)list);
            }
            list.add(action);
        }
    }

    public void commitDocument(@NotNull Document doc) {
        Document document;
        if (doc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.commitDocument must not be null");
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isUncommited(document)) {
            this.doCommit(document, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(final Document document, final PsiFile excludeFile) {
        ArrayList list;
        assert (!(document instanceof DocumentWindow));
        ApplicationManager.getApplication().runWriteAction((Runnable)((Object)new CommitToPsiFileAction(document, this.myProject){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (PsiDocumentManagerImpl.this.isCommittingDocument(document)) {
                    return;
                }
                document.putUserData(KEY_COMMITING, (Object)Boolean.TRUE);
                try {
                    boolean hasCommits = false;
                    try {
                        FileViewProvider viewProvider = PsiDocumentManagerImpl.this.getCachedViewProvider(document);
                        if (viewProvider != null) {
                            List psiFiles = viewProvider.getAllFiles();
                            for (PsiFile file : psiFiles) {
                                if (!file.isValid() || file == excludeFile) continue;
                                hasCommits |= PsiDocumentManagerImpl.this.commit(document, file);
                            }
                            viewProvider.contentsSynchronized();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        PsiDocumentManagerImpl.this.myUncommittedDocuments.remove(document);
                    }
                    if (hasCommits) {
                        InjectedLanguageUtil.commitAllInjectedDocuments(document, PsiDocumentManagerImpl.this.myProject);
                    }
                }
                finally {
                    document.putUserData(KEY_COMMITING, null);
                }
            }
        }));
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            list = (ArrayList)document.getUserData(ACTION_AFTER_COMMIT);
            if (list != null) {
                list = new ArrayList(list);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
    }

    public void commitOtherFilesAssociatedWithDocument(final Document document, final PsiFile psiFile) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider != null && viewProvider.getAllFiles().size() > 1) {
            PostprocessReformattingAspect.getInstance(this.myProject).disablePostprocessFormattingInside(new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManagerImpl.this.doCommit(document, psiFile);
                }
            });
        }
    }

    public <T> T commitAndRunReadAction(final @NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.commitAndRunReadAction must not be null");
        }
        final Ref ref = Ref.create(null);
        this.commitAndRunReadAction(new Runnable(){

            @Override
            public void run() {
                ref.set(computation.compute());
            }
        });
        return (T)ref.get();
    }

    public void commitAndRunReadAction(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.commitAndRunReadAction must not be null");
        }
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable.run();
        } else {
            LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"Don't call commitAndRunReadAction inside ReadAction it may cause a deadlock.");
            final Semaphore s1 = new Semaphore();
            final Semaphore s2 = new Semaphore();
            final boolean[] committed = new boolean[]{false};
            application.runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (PsiDocumentManagerImpl.this.myUncommittedDocuments.isEmpty()) {
                        runnable.run();
                        committed[0] = true;
                    } else {
                        s1.down();
                        s2.down();
                        Runnable commitRunnable = new Runnable(){

                            @Override
                            public void run() {
                                PsiDocumentManagerImpl.this.commitAllDocuments();
                                s1.up();
                                s2.waitFor();
                            }
                        };
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator == null) {
                            ApplicationManager.getApplication().invokeLater(commitRunnable);
                        } else {
                            ApplicationManager.getApplication().invokeLater(commitRunnable, progressIndicator.getModalityState());
                        }
                    }
                }
            });
            if (!committed[0]) {
                s1.waitFor();
                application.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        s2.up();
                        runnable.run();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiDocumentManager.Listener[] getCachedListeners() {
        List<PsiDocumentManager.Listener> list = this.myListeners;
        synchronized (list) {
            if (this.myCachedListeners == null) {
                this.myCachedListeners = this.myListeners.toArray(new PsiDocumentManager.Listener[this.myListeners.size()]);
            }
            return this.myCachedListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.addListener must not be null");
        }
        List<PsiDocumentManager.Listener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.add(listener);
            this.myCachedListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.removeListener must not be null");
        }
        List<PsiDocumentManager.Listener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
            this.myCachedListeners = null;
        }
    }

    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.isDocumentBlockedByPsi must not be null");
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        return viewProvider != null && viewProvider.isLockedByPsiOperations();
    }

    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.doPostponedOperationsAndUnblockDocument must not be null");
        }
        if (doc instanceof DocumentWindow) {
            doc = ((DocumentWindow)doc).getDelegate();
        }
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myProject.getComponent(PostprocessReformattingAspect.class);
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        if (viewProvider != null) {
            component.doPostponedFormatting(viewProvider);
        }
    }

    private void fireDocumentCreated(Document document, PsiFile file) {
        PsiDocumentManager.Listener[] listeners;
        for (PsiDocumentManager.Listener listener : listeners = this.getCachedListeners()) {
            listener.documentCreated(document, file);
        }
    }

    private void fireFileCreated(Document document, PsiFile file) {
        PsiDocumentManager.Listener[] listeners;
        for (PsiDocumentManager.Listener listener : listeners = this.getCachedListeners()) {
            listener.fileCreated(file, document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean commit(Document document, PsiFile file) {
        document.putUserData(this.TEMP_TREE_IN_DOCUMENT_KEY, null);
        TextBlock textBlock = this.getTextBlock(document, file);
        if (textBlock.isEmpty()) {
            return false;
        }
        this.myIsCommitInProgress = true;
        try {
            int lengthShift;
            int endOffset;
            int startOffset;
            if (this.mySmartPointerManager != null) {
                SmartPointerManagerImpl.synchronizePointers(file);
            }
            this.myTreeElementBeingReparsedSoItWontBeCollected = ((PsiFileImpl)file).calcTreeElement();
            if (textBlock.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            textBlock.lock();
            CharSequence chars = document.getCharsSequence();
            Boolean data = (Boolean)document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
            if (data != null) {
                document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
                file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)data);
            }
            if (file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
                int psiEndOffset;
                startOffset = textBlock.getStartOffset();
                endOffset = psiEndOffset = textBlock.getPsiEndOffset();
                lengthShift = textBlock.getTextEndOffset() - psiEndOffset;
            } else {
                startOffset = 0;
                endOffset = document.getTextLength();
                lengthShift = document.getTextLength() - file.getTextLength();
            }
            this.myBlockSupport.reparseRange(file, startOffset, endOffset, lengthShift, chars);
            textBlock.unlock();
            textBlock.clear();
        }
        finally {
            this.myTreeElementBeingReparsedSoItWontBeCollected = null;
            this.myIsCommitInProgress = false;
        }
        return true;
    }

    @NotNull
    public Document[] getUncommittedDocuments() {
        Document[] documentArray = this.myUncommittedDocuments.toArray(new Document[this.myUncommittedDocuments.size()]);
        if (documentArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiDocumentManagerImpl.getUncommittedDocuments must not return null");
        }
        return documentArray;
    }

    public boolean isUncommited(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiDocumentManagerImpl.isUncommited must not be null");
        }
        if (this.getSynchronizer().isInSynchronization(document)) {
            return false;
        }
        return ((DocumentEx)document).isInEventsHandling() || this.myUncommittedDocuments.contains(document);
    }

    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDocumentChange(DocumentEvent event) {
        Document document = event.getDocument();
        FileViewProvider provider = this.getCachedViewProvider(document);
        if (provider == null) {
            return;
        }
        if (provider.getVirtualFile().getFileType().isBinary()) {
            return;
        }
        List files = provider.getAllFiles();
        boolean hasLockedBlocks = false;
        for (PsiFile file : files) {
            if (file == null) continue;
            TextBlock textBlock = this.getTextBlock(document, file);
            if (textBlock.isLocked()) {
                hasLockedBlocks = true;
                continue;
            }
            if (file instanceof PsiFileImpl) {
                this.myIsCommitInProgress = true;
                try {
                    PsiFileImpl psiFile = (PsiFileImpl)file;
                    document.putUserData(this.TEMP_TREE_IN_DOCUMENT_KEY, (Object)psiFile.calcTreeElement());
                }
                finally {
                    this.myIsCommitInProgress = false;
                }
            }
            if (!file.isPhysical() || this.mySmartPointerManager == null) continue;
            SmartPointerManagerImpl.fastenBelts(file);
        }
        if (!hasLockedBlocks) {
            ((SingleRootFileViewProvider)provider).beforeDocumentChanged();
        }
    }

    public void documentChanged(DocumentEvent event) {
        Document document = event.getDocument();
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider != null) {
            if (viewProvider.getVirtualFile().getFileType().isBinary()) {
                return;
            }
            List files = viewProvider.getAllFiles();
            boolean commitNecessary = false;
            for (PsiFile file : files) {
                TextBlock textBlock;
                if (file == null || file instanceof PsiFileImpl && ((PsiFileImpl)file).getTreeElement() == null || (textBlock = this.getTextBlock(document, file)).isLocked()) continue;
                if (this.mySmartPointerManager != null) {
                    SmartPointerManagerImpl.unfastenBelts(file);
                }
                textBlock.documentChanged(event);
                assert (file instanceof PsiFileImpl) : event + "; file=" + file + "; allFiles=" + files + "; viewProvider=" + viewProvider;
                this.myUncommittedDocuments.add(document);
                commitNecessary = true;
            }
            if (commitNecessary && ApplicationManager.getApplication().getCurrentWriteAction(ExternalChangeAction.class) != null) {
                this.commitDocument(document);
            }
        }
    }

    public TextBlock getTextBlock(Document document, PsiFile file) {
        TextBlock textBlock = (TextBlock)((Object)file.getUserData(this.KEY_TEXT_BLOCK));
        if (textBlock == null) {
            textBlock = new TextBlock();
            file.putUserData(this.KEY_TEXT_BLOCK, (Object)textBlock);
        }
        return textBlock;
    }

    public static boolean checkConsistency(PsiFile psiFile, Document document) {
        int i;
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. " + "File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiElement context = psiFile.getContext();
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    public void contentsLoaded(PsiFileImpl file) {
        Document document = this.getCachedDocument(file);
        if (document != null) {
            this.getTextBlock(document, file).clear();
        }
    }

    public void clearUncommitedDocuments() {
        this.myUncommittedDocuments.clear();
    }

    public PsiToDocumentSynchronizer getSynchronizer() {
        return this.mySynchronizer;
    }

    public boolean isCommittingDocument(Document doc) {
        return doc.getUserData(KEY_COMMITING) == Boolean.TRUE;
    }

    public void save() {
        this.commitAllDocuments();
    }
}

