/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UsageInModuleClasspath
extends ProjectStructureElementUsage {
    private final StructureConfigurableContext myContext;
    private final ModuleProjectStructureElement myContainingElement;
    private ProjectStructureElement mySourceElement;
    private Module myModule;

    public UsageInModuleClasspath(@NotNull StructureConfigurableContext context, @NotNull ModuleProjectStructureElement containingElement, ProjectStructureElement sourceElement) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/UsageInModuleClasspath.<init> must not be null");
        }
        if (containingElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/UsageInModuleClasspath.<init> must not be null");
        }
        this.myContext = context;
        this.myContainingElement = containingElement;
        this.myModule = containingElement.getModule();
        this.mySourceElement = sourceElement;
    }

    @Override
    public ProjectStructureElement getSourceElement() {
        return this.mySourceElement;
    }

    @Override
    public ProjectStructureElement getContainingElement() {
        return this.myContainingElement;
    }

    @Override
    public String getPresentableName() {
        return this.myModule.getName();
    }

    public String getModuleName() {
        return this.myModule.getName();
    }

    @Override
    public void navigate() {
        ModulesConfigurator modulesConfigurator = this.myContext.getModulesConfigurator();
        ModuleRootModel rootModel = modulesConfigurator.getRootModel(this.myModule);
        Object entry = this.mySourceElement instanceof LibraryProjectStructureElement ? OrderEntryUtil.findLibraryOrderEntry(rootModel, ((LibraryProjectStructureElement)this.mySourceElement).getLibrary()) : (this.mySourceElement instanceof ModuleProjectStructureElement ? OrderEntryUtil.findModuleOrderEntry(rootModel, ((ModuleProjectStructureElement)this.mySourceElement).getModule()) : (this.mySourceElement instanceof SdkProjectStructureElement ? OrderEntryUtil.findJdkOrderEntry(rootModel, ((SdkProjectStructureElement)this.mySourceElement).getSdk()) : null));
        ModuleStructureConfigurable.getInstance(this.myContext.getProject()).selectOrderEntry(this.myModule, (OrderEntry)entry);
    }

    @Override
    public int hashCode() {
        return this.myModule.hashCode() * 31 + this.mySourceElement.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UsageInModuleClasspath && this.myModule.equals(((UsageInModuleClasspath)obj).myModule) && this.mySourceElement.equals(((UsageInModuleClasspath)obj).mySourceElement);
    }

    @Override
    public Icon getIcon() {
        return this.myModule.getModuleType().getNodeIcon(false);
    }
}

