/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LibraryEditor
implements Disposable {
    private final Library myLibrary;
    private final LibraryEditorListener myListener;
    private String myLibraryName;
    private Library.ModifiableModel myModel;

    public LibraryEditor(Library library, @NotNull LibraryEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditor.<init> must not be null");
        }
        this.myLibraryName = null;
        this.myModel = null;
        this.myLibrary = library;
        this.myListener = listener;
    }

    public String getName() {
        if (this.myLibraryName != null) {
            return this.myLibraryName;
        }
        return this.myLibrary.getName();
    }

    public void dispose() {
        if (this.myModel != null) {
            Disposer.dispose((Disposable)this.myModel);
        }
    }

    public String[] getUrls(OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.getUrls(rootType);
        }
        return this.myLibrary.getUrls(rootType);
    }

    public VirtualFile[] getFiles(OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.getFiles(rootType);
        }
        return this.myLibrary.getFiles(rootType);
    }

    public void setName(String name) {
        String oldName = this.getModel().getName();
        this.myLibraryName = name;
        this.getModel().setName(name);
        this.myListener.libraryRenamed(this.myLibrary, oldName, name);
    }

    public void addRoot(String url, OrderRootType rootType) {
        this.getModel().addRoot(url, rootType);
    }

    public void addRoot(VirtualFile file, OrderRootType rootType) {
        this.getModel().addRoot(file, rootType);
    }

    public void addJarDirectory(String url, boolean recursive) {
        this.getModel().addJarDirectory(url, recursive);
    }

    public void addJarDirectory(VirtualFile file, boolean recursive) {
        this.getModel().addJarDirectory(file, recursive);
    }

    public void removeRoot(String url, OrderRootType rootType) {
        while (this.getModel().removeRoot(url, rootType)) {
        }
    }

    public void commit() {
        if (this.myModel != null) {
            this.myModel.commit();
            this.myModel = null;
            this.myLibraryName = null;
        }
    }

    public Library.ModifiableModel getModel() {
        if (this.myModel == null) {
            this.myModel = this.myLibrary.getModifiableModel();
        }
        return this.myModel;
    }

    public boolean hasChanges() {
        return this.myModel != null && this.myModel.isChanged();
    }

    public boolean isJarDirectory(String url) {
        if (this.myModel != null) {
            return this.myModel.isJarDirectory(url);
        }
        return this.myLibrary.isJarDirectory(url);
    }

    public boolean allPathsValid(OrderRootType orderRootType) {
        if (this.myModel != null) {
            return ((LibraryEx.ModifiableModelEx)this.myModel).allPathsValid(orderRootType);
        }
        return ((LibraryEx)this.myLibrary).allPathsValid(orderRootType);
    }

    public boolean isValid(String url, OrderRootType orderRootType) {
        if (this.myModel != null) {
            return this.myModel.isValid(url, orderRootType);
        }
        return this.myLibrary.isValid(url, orderRootType);
    }
}

