/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl.convertors;

import com.intellij.openapi.project.impl.convertors.Util;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jdom.Element;

public class Convertor23 {
    private static final String PROJECT_ROOT_CONTAINER_CLASS = "com.intellij.projectRoots.ProjectRootContainer";
    private static final String COMPILER_CONFIGURATION_CLASS = "com.intellij.openapi.compiler.Compiler";
    private static final String COMPILER_CONFIGURATION_COMPONENT = "CompilerConfiguration";
    private static final String COMPILER_WORKSPACE_CONFIGURATION_COMPONENT = "CompilerWorkspaceConfiguration";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_OPTION = "option";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_URL = "url";
    private static final String ATTR_EXCLUDE_FROM_COMPILE = "excludeFromCompile";

    public static void execute(Element root) {
        Element rootContComponent = Util.findComponent(root, PROJECT_ROOT_CONTAINER_CLASS);
        if (rootContComponent != null) {
            rootContComponent.setAttribute(ATTR_CLASS, ProjectRootManager.class.getName());
        }
        Convertor23.convertCompilerConfiguration(root);
    }

    public static void convertCompilerConfiguration(Element root) {
        String compileInBackgroundValue = null;
        Element component = Util.findComponent(root, COMPILER_CONFIGURATION_CLASS);
        if (component != null) {
            component.setAttribute(ATTR_NAME, COMPILER_CONFIGURATION_COMPONENT);
            component.removeAttribute(ATTR_CLASS);
            for (Element element : component.getChildren()) {
                String elementName = element.getName();
                if (ATTR_OPTION.equals(elementName)) {
                    String name = element.getAttributeValue(ATTR_NAME);
                    if (name == null || !name.equals("COMPILE_IN_BACKGROUND")) continue;
                    compileInBackgroundValue = element.getAttributeValue(ATTR_VALUE);
                    continue;
                }
                if (!ATTR_EXCLUDE_FROM_COMPILE.equals(elementName)) continue;
                for (Element excludeElement : element.getChildren()) {
                    String path = excludeElement.getAttributeValue(ATTR_PATH);
                    if (path == null) continue;
                    String url = VirtualFileManager.constructUrl((String)"file", (String)path);
                    excludeElement.removeAttribute(ATTR_PATH);
                    excludeElement.setAttribute(ATTR_URL, url);
                }
            }
        }
        if (compileInBackgroundValue != null) {
            component = Util.findComponent(root, COMPILER_WORKSPACE_CONFIGURATION_COMPONENT);
            if (component == null) {
                component = new Element("component");
                component.setAttribute(ATTR_NAME, COMPILER_WORKSPACE_CONFIGURATION_COMPONENT);
                root.addContent(component);
            }
            boolean added = false;
            for (Element element : component.getChildren()) {
                String name;
                String elementName = element.getName();
                if (!ATTR_OPTION.equals(elementName) || (name = element.getAttributeValue(ATTR_NAME)) == null || !name.equals("COMPILE_IN_BACKGROUND")) continue;
                element.setAttribute(ATTR_VALUE, compileInBackgroundValue);
                added = true;
            }
            if (!added) {
                Element compileInBackgroundElement = new Element(ATTR_OPTION);
                compileInBackgroundElement.setAttribute(ATTR_NAME, "COMPILE_IN_BACKGROUND");
                compileInBackgroundElement.setAttribute(ATTR_VALUE, compileInBackgroundValue);
                component.addContent(compileInBackgroundElement);
            }
        }
    }
}

