/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.AppTopics;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextEditorComponent
extends JPanel
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.TextEditorComponent");
    private final Project myProject;
    private final VirtualFile myFile;
    private final TextEditorImpl myTextEditor;
    private final Document myDocument;
    private final MyEditorMouseListener myEditorMouseListener;
    private final MyEditorCaretListener myEditorCaretListener;
    private final MyEditorSelectionListener myEditorSelectionListener;
    private final MyDocumentListener myDocumentListener;
    private final MyEditorPropertyChangeListener myEditorPropertyChangeListener;
    private final MyVirtualFileListener myVirtualFileListener;
    private final Editor myEditor;
    private boolean myModified;
    private boolean myValid;
    private final MessageBusConnection myConnection;

    TextEditorComponent(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextEditorImpl textEditor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorComponent.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorComponent.<init> must not be null");
        }
        if (textEditor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorComponent.<init> must not be null");
        }
        super(new BorderLayout(), true);
        TextEditorComponent.assertThread();
        this.myProject = project;
        this.myFile = file;
        this.myTextEditor = textEditor;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        LOG.assertTrue(this.myDocument != null);
        this.myDocumentListener = new MyDocumentListener();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
        this.myEditorMouseListener = new MyEditorMouseListener();
        this.myEditorCaretListener = new MyEditorCaretListener();
        this.myEditorSelectionListener = new MyEditorSelectionListener();
        this.myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
        this.myConnection = project.getMessageBus().connect();
        this.myConnection.subscribe(AppTopics.FILE_TYPES, (Object)new MyFileTypeListener());
        this.myVirtualFileListener = new MyVirtualFileListener();
        this.myFile.getFileSystem().addVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
        this.myEditor = this.createEditor();
        this.add((Component)this.myEditor.getComponent(), "Center");
        this.myModified = this.isModifiedImpl();
        this.myValid = this.isEditorValidImpl();
        LOG.assertTrue(this.myValid);
    }

    void dispose() {
        this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
        this.disposeEditor(this.myEditor);
        this.myConnection.disconnect();
        this.myFile.getFileSystem().removeVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
    }

    void selectNotify() {
        this.updateStatusBar();
    }

    void deselectNotify() {
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar == null) {
            return;
        }
        statusBar.clear();
    }

    private static void assertThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    Editor getEditor() {
        return this.myEditor;
    }

    private Editor createEditor() {
        Editor editor = EditorFactory.getInstance().createEditor(this.myDocument, this.myProject);
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myFile, EditorColorsManager.getInstance().getGlobalScheme(), this.myProject);
        ((EditorEx)editor).setHighlighter(highlighter);
        ((EditorEx)editor).setFile(this.myFile);
        editor.addEditorMouseListener((EditorMouseListener)this.myEditorMouseListener);
        editor.getCaretModel().addCaretListener((CaretListener)this.myEditorCaretListener);
        editor.getSelectionModel().addSelectionListener((SelectionListener)this.myEditorSelectionListener);
        ((EditorEx)editor).addPropertyChangeListener(this.myEditorPropertyChangeListener);
        ((EditorImpl)editor).setDropHandler(new FileDropHandler());
        TextEditorProvider.putTextEditor(editor, this.myTextEditor);
        return editor;
    }

    private void disposeEditor(Editor editor) {
        EditorFactory.getInstance().releaseEditor(editor);
        editor.removeEditorMouseListener((EditorMouseListener)this.myEditorMouseListener);
        editor.getCaretModel().removeCaretListener((CaretListener)this.myEditorCaretListener);
        editor.getSelectionModel().removeSelectionListener((SelectionListener)this.myEditorSelectionListener);
        ((EditorEx)editor).removePropertyChangeListener(this.myEditorPropertyChangeListener);
    }

    boolean isModified() {
        TextEditorComponent.assertThread();
        return this.myModified;
    }

    private boolean isModifiedImpl() {
        return FileDocumentManager.getInstance().isFileModified(this.myFile);
    }

    private void updateModifiedProperty() {
        Boolean oldModified = this.myModified;
        this.myModified = this.isModifiedImpl();
        this.myTextEditor.firePropertyChange("modified", oldModified, this.myModified);
    }

    boolean isEditorValid() {
        return this.myValid;
    }

    private boolean isEditorValidImpl() {
        return FileDocumentManager.getInstance().getDocument(this.myFile) != null;
    }

    private void updateValidProperty() {
        Boolean oldValid = this.myValid;
        this.myValid = this.isEditorValidImpl();
        this.myTextEditor.firePropertyChange("valid", oldValid, this.myValid);
    }

    private void updateHighlighters() {
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFile);
        ((EditorEx)this.myEditor).setHighlighter(highlighter);
    }

    private void updateStatusBar() {
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar == null) {
            return;
        }
        statusBar.update(this.getEditor());
    }

    @Nullable
    private Editor validateCurrentEditor() {
        JComponent jComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return this.myEditor;
    }

    public Object getData(String dataId) {
        Object o;
        Editor e = this.validateCurrentEditor();
        if (e == null) {
            return null;
        }
        if (!this.myProject.isDisposed() && (o = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.myProject)).getData(dataId, e, this.myFile)) != null) {
            return o;
        }
        if (PlatformDataKeys.EDITOR.is(dataId)) {
            return e;
        }
        if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile.isValid() ? this.myFile : null;
        }
        return null;
    }

    private final class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(VirtualFilePropertyEvent e) {
            if ("name".equals(e.getPropertyName())) {
                TextEditorComponent.this.updateValidProperty();
                if (TextEditorComponent.this.isValid()) {
                    TextEditorComponent.this.updateHighlighters();
                }
            }
        }

        public void contentsChanged(VirtualFileEvent event) {
            if (event.isFromSave()) {
                TextEditorComponent.assertThread();
                VirtualFile file = event.getFile();
                LOG.assertTrue(file.isValid());
                if (TextEditorComponent.this.myFile.equals(file)) {
                    TextEditorComponent.this.updateModifiedProperty();
                }
            }
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void beforeFileTypesChanged(FileTypeEvent event) {
        }

        public void fileTypesChanged(FileTypeEvent event) {
            TextEditorComponent.assertThread();
            TextEditorComponent.this.updateValidProperty();
            if (TextEditorComponent.this.isValid()) {
                TextEditorComponent.this.updateHighlighters();
            }
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            TextEditorComponent.assertThread();
            String propertyName = e.getPropertyName();
            if ("insertMode".equals(propertyName) || "columnMode".equals(propertyName)) {
                TextEditorComponent.this.updateStatusBar();
            }
        }
    }

    private final class MyDocumentListener
    extends DocumentAdapter {
        private final Runnable myUpdateRunnable;

        public MyDocumentListener() {
            this.myUpdateRunnable = new Runnable(){

                @Override
                public void run() {
                    TextEditorComponent.this.updateModifiedProperty();
                }
            };
        }

        public void documentChanged(DocumentEvent e) {
            ApplicationManager.getApplication().invokeLater(this.myUpdateRunnable);
        }
    }

    private final class MyEditorSelectionListener
    implements SelectionListener {
        private MyEditorSelectionListener() {
        }

        public void selectionChanged(SelectionEvent e) {
            TextEditorComponent.assertThread();
            if (e.getEditor() == TextEditorComponent.this.getEditor()) {
                TextEditorComponent.this.updateStatusBar();
            }
        }
    }

    private final class MyEditorCaretListener
    implements CaretListener {
        private MyEditorCaretListener() {
        }

        public void caretPositionChanged(CaretEvent e) {
            TextEditorComponent.assertThread();
            if (e.getEditor() == TextEditorComponent.this.getEditor()) {
                TextEditorComponent.this.updateStatusBar();
            }
        }
    }

    private static final class MyEditorMouseListener
    extends EditorPopupHandler {
        private MyEditorMouseListener() {
        }

        @Override
        public void invokePopup(EditorMouseEvent event) {
            if (!event.isConsumed() && event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorPopupMenu");
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", group);
                MouseEvent e = event.getMouseEvent();
                Component c = e.getComponent();
                if (c != null && c.isShowing()) {
                    popupMenu.getComponent().show(c, e.getX(), e.getY());
                }
                e.consume();
            }
        }
    }
}

