/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class StickyButtonUI<B extends AbstractButton>
extends BasicToggleButtonUI {
    public static final float FONT_SIZE = 11.0f;

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setFont(UIManager.getFont("Button.font").deriveFont(1, 11.0f));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ButtonModel model;
        AbstractButton button = (AbstractButton)c;
        int width = button.getWidth();
        int height = button.getHeight();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int arcSize = this.getArcSize();
        if (c.isOpaque()) {
            g2.setColor(c.getBackground());
            g2.fillRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
        }
        if ((model = button.getModel()).isSelected()) {
            g2.setColor(this.getSelectionColor(button));
            g2.fillRoundRect(0, 0, width - 1, height - 1, this.getArcSize(), this.getArcSize());
        } else if (model.isRollover()) {
            g2.setColor(this.getRolloverColor(button));
            g2.fillRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
        } else {
            Color bg = this.getBackgroundColor(button);
            if (bg != null) {
                g2.setColor(bg);
                g2.fillRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
            }
        }
        if (button.hasFocus()) {
            g2.setColor(this.getFocusColor(button));
            g2.drawRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
        }
        g2.dispose();
        super.paint(g, c);
    }

    protected Color getFocusColor(B button) {
        return new Color(100, 100, 100);
    }

    protected Color getSelectionColor(B button) {
        return Color.GRAY;
    }

    protected Color getRolloverColor(B button) {
        return Color.LIGHT_GRAY;
    }

    protected Color getBackgroundColor(B button) {
        return null;
    }

    protected int getArcSize() {
        return 10;
    }
}

