/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class StartupManagerImpl
extends StartupManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.impl.StartupManagerImpl");
    private final List<Runnable> myPreStartupActivities = Collections.synchronizedList(new ArrayList());
    private final List<Runnable> myStartupActivities = new ArrayList<Runnable>();
    private final List<Runnable> myPostStartupActivities = Collections.synchronizedList(new ArrayList());
    private final List<CacheUpdater> myCacheUpdaters = new LinkedList<CacheUpdater>();
    private volatile boolean myPreStartupActivitiesPassed = false;
    private volatile boolean myStartupActivitiesRunning = false;
    private volatile boolean myStartupActivitiesPassed = false;
    private volatile boolean myPostStartupActivitiesPassed = false;
    private final Project myProject;

    public StartupManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerPreStartupActivity(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/startup/impl/StartupManagerImpl.registerPreStartupActivity must not be null");
        }
        LOG.assertTrue(!this.myPreStartupActivitiesPassed, (Object)"Registering pre startup activity that will never be run");
        this.myPreStartupActivities.add(runnable);
    }

    public void registerStartupActivity(Runnable runnable) {
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        this.myStartupActivities.add(runnable);
    }

    public synchronized void registerPostStartupActivity(Runnable runnable) {
        LOG.assertTrue(!this.myPostStartupActivitiesPassed, (Object)"Registering post-startup activity that will never be run");
        this.myPostStartupActivities.add(runnable);
    }

    public void registerCacheUpdater(CacheUpdater updater) {
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)(CacheUpdater.class.getSimpleName() + " must be registered before startup activity finished"));
        this.myCacheUpdaters.add(updater);
    }

    @Override
    public boolean startupActivityRunning() {
        return this.myStartupActivitiesRunning;
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    @Override
    public boolean postStartupActivityPassed() {
        return this.myPostStartupActivitiesPassed;
    }

    public void runStartupActivities() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                assert (!HeavyProcessLatch.INSTANCE.isRunning());
                HeavyProcessLatch.INSTANCE.processStarted();
                try {
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myPreStartupActivities);
                    StartupManagerImpl.this.myPreStartupActivitiesPassed = true;
                    StartupManagerImpl.this.myStartupActivitiesRunning = true;
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myStartupActivities);
                    StartupManagerImpl.this.myStartupActivitiesRunning = false;
                    StartupManagerImpl.this.startCacheUpdate();
                    StartupManagerImpl.this.myStartupActivitiesPassed = true;
                }
                finally {
                    HeavyProcessLatch.INSTANCE.processFinished();
                }
            }
        });
    }

    public synchronized void runPostStartupActivities() {
        Application app = ApplicationManager.getApplication();
        app.assertIsDispatchThread();
        if (this.myPostStartupActivitiesPassed) {
            return;
        }
        ArrayList dumbAware = CollectionFactory.arrayList();
        final ArrayList nonDumbAware = CollectionFactory.arrayList();
        for (Runnable each : this.myPostStartupActivities) {
            if (each instanceof DumbAware) {
                dumbAware.add(each);
                continue;
            }
            nonDumbAware.add(each);
        }
        StartupManagerImpl.runActivities(dumbAware);
        DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

            @Override
            public void run() {
                if (StartupManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                StartupManagerImpl.runActivities(nonDumbAware);
                StartupManagerImpl.this.myPostStartupActivitiesPassed = true;
                StartupManagerImpl.this.myPostStartupActivities.clear();
            }
        });
        if (!app.isUnitTestMode()) {
            VirtualFileManager.getInstance().refresh(!app.isHeadlessEnvironment());
        }
    }

    private void startCacheUpdate() {
        try {
            DumbServiceImpl.getInstance(this.myProject).queueCacheUpdate(this.myCacheUpdaters);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private static void runActivities(List<Runnable> activities) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        while (!activities.isEmpty()) {
            Runnable runnable = activities.remove(0);
            if (indicator != null) {
                indicator.checkCanceled();
            }
            try {
                runnable.run();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable ex) {
                LOG.error(ex);
            }
        }
    }

    public void runWhenProjectIsInitialized(final Runnable action) {
        final Application application = ApplicationManager.getApplication();
        Object runnable = action instanceof DumbAware ? new DumbAwareRunnable(){

            public void run() {
                application.runWriteAction(action);
            }
        } : new Runnable(){

            @Override
            public void run() {
                application.runWriteAction(action);
            }
        };
        if (this.myProject.isInitialized() || application.isUnitTestMode() && this.myPostStartupActivitiesPassed) {
            if (application.isDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(new Runnable((Runnable)runnable){
                    final /* synthetic */ Runnable val$runnable;
                    {
                        this.val$runnable = runnable;
                    }

                    @Override
                    public void run() {
                        if (!StartupManagerImpl.this.myProject.isDisposed()) {
                            this.val$runnable.run();
                        }
                    }
                });
            }
        } else {
            this.registerPostStartupActivity((Runnable)runnable);
        }
    }

    public void prepareForNextTest() {
        this.myPreStartupActivities.clear();
        this.myStartupActivities.clear();
        this.myPostStartupActivities.clear();
        this.myCacheUpdaters.clear();
        this.myPreStartupActivitiesPassed = false;
        this.myStartupActivitiesRunning = false;
        this.myStartupActivitiesPassed = false;
        this.myPostStartupActivitiesPassed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCleared() {
        try {
            assert (this.myStartupActivities.isEmpty()) : "Activities: " + this.myStartupActivities;
            assert (this.myPostStartupActivities.isEmpty()) : "Post Activities: " + this.myPostStartupActivities;
            assert (this.myPreStartupActivities.isEmpty()) : "Pre Activities: " + this.myPreStartupActivities;
        }
        finally {
            this.prepareForNextTest();
        }
    }
}

