/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesDefaults {
    private final String myDefaultName;
    private final TextRange myDefaultRange;
    private final Map<String, Pair<String, TextRange>> myNamesToValueAndRangeMap = new HashMap();

    public AttributesDefaults(@NonNls @Nullable String defaultName, @Nullable TextRange defaultRange) {
        this.myDefaultName = defaultName;
        this.myDefaultRange = defaultRange;
    }

    public AttributesDefaults(@NonNls @Nullable String defaultName) {
        this(defaultName, null);
    }

    public AttributesDefaults() {
        this(null, null);
    }

    @Nullable
    public String getDefaultFileName() {
        return this.myDefaultName;
    }

    @Nullable
    public TextRange getDefaultFileNameSelection() {
        return this.myDefaultRange;
    }

    public void add(@NonNls @NotNull String attributeKey, @NonNls @NotNull String value, @Nullable TextRange selectionRange) {
        if (attributeKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/actions/AttributesDefaults.add must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/actions/AttributesDefaults.add must not be null");
        }
        this.myNamesToValueAndRangeMap.put(attributeKey, (Pair<String, TextRange>)new Pair((Object)value, (Object)selectionRange));
    }

    public void add(@NonNls @NotNull String attributeKey, @NonNls @NotNull String value) {
        if (attributeKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/actions/AttributesDefaults.add must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/actions/AttributesDefaults.add must not be null");
        }
        this.add(attributeKey, value, null);
    }

    @Nullable
    public TextRange getRangeFor(@NonNls @NotNull String attributeKey) {
        if (attributeKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/actions/AttributesDefaults.getRangeFor must not be null");
        }
        Pair<String, TextRange> valueAndRange = this.myNamesToValueAndRangeMap.get(attributeKey);
        return valueAndRange == null ? null : (TextRange)valueAndRange.second;
    }

    @Nullable
    public String getDefaultValueFor(@NonNls @NotNull String attributeKey) {
        if (attributeKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/actions/AttributesDefaults.getDefaultValueFor must not be null");
        }
        Pair<String, TextRange> valueAndRange = this.myNamesToValueAndRangeMap.get(attributeKey);
        return valueAndRange == null ? null : (String)valueAndRange.first;
    }
}

