/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views.table;

import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.FormatUtil;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import javax.swing.table.AbstractTableModel;

public class RevisionsTableModel
extends AbstractTableModel {
    private final HistoryDialogModel myModel;

    public RevisionsTableModel(HistoryDialogModel m) {
        this.myModel = m;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.myModel.getRevisions().size();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return LocalHistoryBundle.message("revisions.table.date", new Object[0]);
        }
        if (column == 1) {
            return LocalHistoryBundle.message("revisions.table.revision", new Object[0]);
        }
        if (column == 2) {
            return LocalHistoryBundle.message("revisions.table.action", new Object[0]);
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Revision r = this.getRevisionAt(row);
        if (column == 0) {
            return FormatUtil.formatTimestamp(r.getTimestamp());
        }
        if (column == 1) {
            return r.getName();
        }
        if (column == 2) {
            return r.getCauseChangeName();
        }
        return null;
    }

    public Revision getRevisionAt(int row) {
        return this.myModel.getRevisions().get(row);
    }
}

