/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.featureStatistics.ProductivityFeaturesRegistryImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="FeatureUsageStatistics", storages={@Storage(id="other", file="$APP_CONFIG$/feature.usage.statistics.xml")})
public class FeatureUsageTrackerImpl
extends FeatureUsageTracker
implements PersistentStateComponent<Element> {
    private static final long DAY = 86400000L;
    private long FIRST_RUN_TIME = 0L;
    boolean HAVE_BEEN_SHOWN = false;
    private final ProductivityFeaturesRegistry myRegistry;
    @NonNls
    private static final String FEATURE_TAG = "feature";
    @NonNls
    private static final String ATT_SHOW_IN_OTHER = "show-in-other";
    @NonNls
    private static final String ATT_SHOW_IN_COMPILATION = "show-in-compilation";
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_FIRST_RUN = "first-run";
    @NonNls
    private static final String ATT_HAVE_BEEN_SHOWN = "have-been-shown";

    public FeatureUsageTrackerImpl(ProductivityFeaturesRegistry productivityFeaturesRegistry) {
        this.myRegistry = productivityFeaturesRegistry;
    }

    String[] getFeaturesToShow(Project project) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : ProductivityFeaturesRegistry.getInstance().getFeatureIds()) {
            if (!this.isToBeShown(id, project)) continue;
            result.add(id);
        }
        return ArrayUtil.toStringArray(result);
    }

    public boolean isToBeShown(String featureId, Project project) {
        ApplicabilityFilter[] filters;
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        FeatureDescriptor descriptor = registry.getFeatureDescriptor(featureId);
        if (descriptor == null || !descriptor.isUnused()) {
            return false;
        }
        String[] dependencyFeatures = descriptor.getDependencyFeatures();
        boolean locked = dependencyFeatures.length > 0;
        for (int i = 0; locked && i < dependencyFeatures.length; ++i) {
            if (registry.getFeatureDescriptor(dependencyFeatures[i]).isUnused()) continue;
            locked = false;
        }
        if (locked) {
            return false;
        }
        for (ApplicabilityFilter filter : filters = registry.getMatchingFilters(featureId)) {
            if (filter.isApplicable(featureId, project)) continue;
            return false;
        }
        long current = System.currentTimeMillis();
        long succesive_interval = (long)descriptor.getDaysBetweenSuccesiveShowUps() * 86400000L + (long)(descriptor.getShownCount() * 2);
        long firstShowUpInterval = (long)descriptor.getDaysBeforeFirstShowUp() * 86400000L;
        long lastTimeUsed = descriptor.getLastTimeUsed();
        long lastTimeShown = descriptor.getLastTimeShown();
        return lastTimeShown == 0L && firstShowUpInterval + this.getFirstRunTime() < current || lastTimeShown > 0L && current - lastTimeShown > succesive_interval && current - lastTimeUsed > succesive_interval;
    }

    public long getFirstRunTime() {
        if (this.FIRST_RUN_TIME == 0L) {
            this.FIRST_RUN_TIME = System.currentTimeMillis();
        }
        return this.FIRST_RUN_TIME;
    }

    public void loadState(Element element) {
        List featuresList = element.getChildren(FEATURE_TAG);
        for (Object aFeaturesList : featuresList) {
            Element featureElement = (Element)aFeaturesList;
            FeatureDescriptor descriptor = ((ProductivityFeaturesRegistryImpl)this.myRegistry).getFeatureDescriptorEx(featureElement.getAttributeValue(ATT_ID));
            if (descriptor == null) continue;
            descriptor.readStatistics(featureElement);
        }
        try {
            this.FIRST_RUN_TIME = Long.parseLong(element.getAttributeValue(ATT_FIRST_RUN));
        }
        catch (NumberFormatException e) {
            this.FIRST_RUN_TIME = 0L;
        }
        this.HAVE_BEEN_SHOWN = Boolean.valueOf(element.getAttributeValue(ATT_HAVE_BEEN_SHOWN));
        this.SHOW_IN_OTHER_PROGRESS = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IN_OTHER, Boolean.toString(true)));
        this.SHOW_IN_COMPILATION_PROGRESS = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IN_COMPILATION, Boolean.toString(true)));
    }

    public Element getState() {
        Element element = new Element("state");
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        Set ids = registry.getFeatureIds();
        for (String id : ids) {
            Element featureElement = new Element(FEATURE_TAG);
            featureElement.setAttribute(ATT_ID, id);
            FeatureDescriptor descriptor = registry.getFeatureDescriptor(id);
            descriptor.writeStatistics(featureElement);
            element.addContent(featureElement);
        }
        element.setAttribute(ATT_FIRST_RUN, String.valueOf(this.getFirstRunTime()));
        element.setAttribute(ATT_HAVE_BEEN_SHOWN, String.valueOf(this.HAVE_BEEN_SHOWN));
        element.setAttribute(ATT_SHOW_IN_OTHER, String.valueOf(this.SHOW_IN_OTHER_PROGRESS));
        element.setAttribute(ATT_SHOW_IN_COMPILATION, String.valueOf(this.SHOW_IN_COMPILATION_PROGRESS));
        return element;
    }

    public void triggerFeatureUsed(String featureId) {
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        FeatureDescriptor descriptor = registry.getFeatureDescriptor(featureId);
        if (descriptor != null) {
            descriptor.triggerUsed();
        }
    }

    public void triggerFeatureShown(String featureId) {
        FeatureDescriptor descriptor = ProductivityFeaturesRegistry.getInstance().getFeatureDescriptor(featureId);
        if (descriptor != null) {
            descriptor.triggerShown();
        }
    }
}

