/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.autodetecting.DetectedFacetPresentation;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.autodetecting.FacetDetectorRegistry;
import com.intellij.facet.autodetecting.UnderlyingFacetSelector;
import com.intellij.facet.impl.autodetecting.DefaultDetectedFacetPresentation;
import com.intellij.facet.impl.autodetecting.FacetDetectorForWizardRegistry;
import com.intellij.facet.impl.autodetecting.FacetOnTheFlyDetectorRegistry;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.VirtualFilePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetDetectorRegistryEx<C extends FacetConfiguration>
implements FacetDetectorRegistry<C> {
    @Nullable
    private final FacetDetectorForWizardRegistry<C> myForWizardDelegate;
    @Nullable
    private final FacetOnTheFlyDetectorRegistry<C> myOnTheFlyDelegate;
    private DetectedFacetPresentation myPresentation;

    public FacetDetectorRegistryEx(@Nullable FacetDetectorForWizardRegistry<C> forWizardDelegate, @Nullable FacetOnTheFlyDetectorRegistry<C> onTheFlyDelegate) {
        this.myForWizardDelegate = forWizardDelegate;
        this.myOnTheFlyDelegate = onTheFlyDelegate;
    }

    public void customizeDetectedFacetPresentation(@NotNull DetectedFacetPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.customizeDetectedFacetPresentation must not be null");
        }
        this.myPresentation = presentation;
    }

    public <U extends FacetConfiguration> void registerUniversalDetectorByFileNameAndRootTag(@NotNull @NonNls String fileName, @NotNull @NonNls String rootTag, @NotNull FacetDetector<VirtualFile, C> detector, @Nullable UnderlyingFacetSelector<VirtualFile, U> underlyingFacetSelector) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetectorByFileNameAndRootTag must not be null");
        }
        if (rootTag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetectorByFileNameAndRootTag must not be null");
        }
        if (detector == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetectorByFileNameAndRootTag must not be null");
        }
        VirtualFilePattern fileNamePattern = PlatformPatterns.virtualFile().withName((ElementPattern)StandardPatterns.string().equalTo((Object)fileName));
        VirtualFilePattern wizardPattern = fileNamePattern.xmlWithRootTag((ElementPattern)StandardPatterns.string().equalTo((Object)rootTag));
        if (underlyingFacetSelector != null) {
            this.registerSubFacetDetectorForWizard((FileType)StdFileTypes.XML, wizardPattern, detector, underlyingFacetSelector);
        } else {
            this.registerDetectorForWizard((FileType)StdFileTypes.XML, wizardPattern, detector);
        }
        this.registerOnTheFlySubFacetDetector((FileType)StdFileTypes.XML, fileNamePattern, (ElementPattern<PsiFile>)XmlPatterns.xmlFile().withRootTag((ElementPattern)XmlPatterns.xmlTag().withName(rootTag)), FacetDetectorRegistryEx.convertDetector(detector), underlyingFacetSelector);
    }

    public void registerDetectorForWizard(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull FacetDetector<VirtualFile, C> facetDetector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerDetectorForWizard must not be null");
        }
        if (virtualFileFilter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerDetectorForWizard must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerDetectorForWizard must not be null");
        }
        if (this.myForWizardDelegate != null) {
            this.myForWizardDelegate.register(fileType, virtualFileFilter, facetDetector);
        }
    }

    public void registerDetectorForWizard(@NotNull FileType fileType, @NotNull VirtualFilePattern virtualFilePattern, @NotNull FacetDetector<VirtualFile, C> facetDetector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerDetectorForWizard must not be null");
        }
        if (virtualFilePattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerDetectorForWizard must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerDetectorForWizard must not be null");
        }
        this.registerDetectorForWizard(fileType, new MyPatternFilter(virtualFilePattern), facetDetector);
    }

    public <U extends FacetConfiguration> void registerSubFacetDetectorForWizard(@NotNull FileType fileType, @NotNull VirtualFilePattern virtualFilePattern, @NotNull FacetDetector<VirtualFile, C> facetDetector, @NotNull UnderlyingFacetSelector<VirtualFile, U> underlyingFacetSelector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerSubFacetDetectorForWizard must not be null");
        }
        if (virtualFilePattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerSubFacetDetectorForWizard must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerSubFacetDetectorForWizard must not be null");
        }
        if (underlyingFacetSelector == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerSubFacetDetectorForWizard must not be null");
        }
        if (this.myForWizardDelegate != null) {
            this.myForWizardDelegate.register(fileType, new MyPatternFilter(virtualFilePattern), facetDetector, underlyingFacetSelector);
        }
    }

    private <U extends FacetConfiguration> void registerOnTheFlyDetector(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull Condition<PsiFile> psiFileFilter, @NotNull FacetDetector<PsiFile, C> facetDetector, @Nullable UnderlyingFacetSelector<VirtualFile, U> selector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (virtualFileFilter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (psiFileFilter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (this.myOnTheFlyDelegate != null) {
            this.myOnTheFlyDelegate.register(fileType, virtualFileFilter, psiFileFilter, facetDetector, selector);
        }
    }

    public <U extends FacetConfiguration> void registerOnTheFlySubFacetDetector(@NotNull FileType fileType, @NotNull VirtualFilePattern virtualFilePattern, final @NotNull ElementPattern<? extends PsiFile> psiFilePattern, @NotNull FacetDetector<PsiFile, C> facetDetector, UnderlyingFacetSelector<VirtualFile, U> selector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlySubFacetDetector must not be null");
        }
        if (virtualFilePattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlySubFacetDetector must not be null");
        }
        if (psiFilePattern == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlySubFacetDetector must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlySubFacetDetector must not be null");
        }
        this.registerOnTheFlyDetector(fileType, new MyPatternFilter(virtualFilePattern), new Condition<PsiFile>(){

            public boolean value(PsiFile psiFile) {
                return psiFilePattern.accepts((Object)psiFile);
            }
        }, facetDetector, selector);
    }

    public void registerOnTheFlyDetector(@NotNull FileType fileType, @NotNull VirtualFilePattern virtualFilePattern, @NotNull ElementPattern<? extends PsiFile> psiFilePattern, @NotNull FacetDetector<PsiFile, C> facetDetector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (virtualFilePattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (psiFilePattern == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        this.registerOnTheFlySubFacetDetector(fileType, virtualFilePattern, psiFilePattern, facetDetector, null);
    }

    public void registerOnTheFlyDetector(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull Condition<PsiFile> psiFileFilter, @NotNull FacetDetector<PsiFile, C> facetDetector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (virtualFileFilter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (psiFileFilter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerOnTheFlyDetector must not be null");
        }
        this.registerOnTheFlyDetector(fileType, virtualFileFilter, psiFileFilter, facetDetector, null);
    }

    public void registerUniversalDetector(@NotNull FileType fileType, @NotNull VirtualFilePattern virtualFilePattern, @NotNull FacetDetector<VirtualFile, C> facetDetector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetector must not be null");
        }
        if (virtualFilePattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetector must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetector must not be null");
        }
        this.registerUniversalDetector(fileType, new MyPatternFilter(virtualFilePattern), facetDetector);
    }

    public void registerUniversalDetector(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull FacetDetector<VirtualFile, C> facetDetector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetector must not be null");
        }
        if (virtualFileFilter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetector must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalDetector must not be null");
        }
        if (this.myForWizardDelegate != null) {
            this.myForWizardDelegate.register(fileType, virtualFileFilter, facetDetector);
        }
        if (this.myOnTheFlyDelegate != null) {
            this.myOnTheFlyDelegate.register(fileType, virtualFileFilter, facetDetector, null);
        }
    }

    public <U extends FacetConfiguration> void registerUniversalSubFacetDetector(@NotNull FileType fileType, @NotNull VirtualFilePattern virtualFilePattern, @NotNull FacetDetector<VirtualFile, C> facetDetector, UnderlyingFacetSelector<VirtualFile, U> underlyingFacetSelector) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalSubFacetDetector must not be null");
        }
        if (virtualFilePattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalSubFacetDetector must not be null");
        }
        if (facetDetector == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.registerUniversalSubFacetDetector must not be null");
        }
        this.registerSubFacetDetectorForWizard(fileType, virtualFilePattern, facetDetector, underlyingFacetSelector);
        if (this.myOnTheFlyDelegate != null) {
            this.myOnTheFlyDelegate.register(fileType, new MyPatternFilter(virtualFilePattern), facetDetector, underlyingFacetSelector);
        }
    }

    public static <C extends FacetConfiguration> FacetDetector<PsiFile, C> convertDetector(final FacetDetector<VirtualFile, C> detector) {
        return new FacetDetector<PsiFile, C>(detector.getId() + "-psi"){

            public C detectFacet(PsiFile source, Collection<C> existentFacetConfigurations) {
                VirtualFile virtualFile = source.getVirtualFile();
                return virtualFile != null ? detector.detectFacet((Object)virtualFile, existentFacetConfigurations) : null;
            }

            public void beforeFacetAdded(@NotNull Facet facet, FacetModel facetModel, @NotNull ModifiableRootModel modifiableRootModel) {
                if (facet == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx$2.beforeFacetAdded must not be null");
                }
                if (modifiableRootModel == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx$2.beforeFacetAdded must not be null");
                }
                detector.beforeFacetAdded(facet, facetModel, modifiableRootModel);
            }

            public void afterFacetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx$2.afterFacetAdded must not be null");
                }
                detector.afterFacetAdded(facet);
            }
        };
    }

    @NotNull
    public static <C extends FacetConfiguration> DetectedFacetPresentation getDetectedFacetPresentation(@NotNull FacetType<?, C> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.getDetectedFacetPresentation must not be null");
        }
        FacetDetectorRegistryEx<C> registry = new FacetDetectorRegistryEx<C>(null, null);
        facetType.registerDetectors(registry);
        DetectedFacetPresentation presentation = registry.myPresentation;
        Object object = presentation != null ? presentation : DefaultDetectedFacetPresentation.INSTANCE;
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/autodetecting/FacetDetectorRegistryEx.getDetectedFacetPresentation must not return null");
        }
        return object;
    }

    private static class MyPatternFilter
    implements VirtualFileFilter {
        private final VirtualFilePattern myVirtualFilePattern;

        public MyPatternFilter(VirtualFilePattern virtualFilePattern) {
            this.myVirtualFilePattern = virtualFilePattern;
        }

        public boolean accept(VirtualFile file) {
            return this.myVirtualFilePattern.accepts((Object)file);
        }
    }
}

