/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.util.text.StringUtil;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NonNls;

public class LogMessage
extends AbstractMessage {
    @NonNls
    static final String NO_MESSAGE = "No message";
    private String myHeader = "No message";
    private final Throwable myThrowable;

    public LogMessage(LoggingEvent aEvent) {
        this.myThrowable = aEvent.getThrowableInformation() == null ? null : aEvent.getThrowableInformation().getThrowable();
        this.myHeader = aEvent.getMessage() == null || aEvent.getMessage().toString().length() == 0 ? this.getThrowable().toString() : aEvent.getMessage().toString();
    }

    public LogMessage(IdeaLoggingEvent aEvent) {
        this.myThrowable = aEvent.getThrowable();
        if (StringUtil.isNotEmpty((String)aEvent.getMessage())) {
            this.myHeader = aEvent.getMessage();
        }
        if (this.myThrowable != null && StringUtil.isNotEmpty((String)this.myThrowable.getMessage())) {
            if (this.myHeader != NO_MESSAGE) {
                if (!this.myHeader.endsWith(": ") && !this.myHeader.endsWith(":")) {
                    this.myHeader = this.myHeader + ": ";
                }
                this.myHeader = this.myHeader + this.myThrowable.getMessage();
            } else {
                this.myHeader = this.myThrowable.getMessage();
            }
        }
    }

    @Override
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @Override
    public String getMessage() {
        return this.myHeader;
    }

    @Override
    public String getThrowableText() {
        return StringUtil.getThrowableText((Throwable)this.getThrowable());
    }
}

