/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ClassRenderer");
    @NonNls
    public static final String UNIQUE_ID = "ClassRenderer";
    public boolean SORT_ASCENDING = false;
    public boolean SHOW_SYNTHETICS = true;
    public boolean SHOW_STATIC = false;
    public boolean SHOW_STATIC_FINAL = false;
    public boolean SHOW_DECLARED_TYPE = false;
    public boolean SHOW_OBJECT_ID = true;

    public ClassRenderer() {
        this.myProperties.setEnabled(true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public boolean isEnabled() {
        return this.myProperties.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myProperties.setEnabled(enabled);
    }

    @Override
    public ClassRenderer clone() {
        return (ClassRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
        return ClassRenderer.calcLabel(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String calcLabel(ValueDescriptor descriptor) {
        ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
        Value value = valueDescriptor.getValue();
        if (value instanceof ObjectReference) {
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                if (value instanceof StringReference) {
                    buf.append('\"');
                    buf.append(((StringReference)value).value());
                    buf.append('\"');
                } else if (value instanceof ClassObjectReference) {
                    ReferenceType type = ((ClassObjectReference)value).reflectedType();
                    buf.append(type != null ? type.name() : "{...}");
                } else {
                    ObjectReference objRef = (ObjectReference)value;
                    Type type = objRef.type();
                    if (type instanceof ClassType && ((ClassType)type).isEnum()) {
                        String name = ClassRenderer.getEnumConstantName(objRef, (ClassType)type);
                        if (name != null) {
                            buf.append(name);
                        } else {
                            buf.append(type.name());
                        }
                    } else {
                        buf.append(ValueDescriptorImpl.getIdLabel(objRef));
                    }
                }
                String string = buf.toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }
        if (value == null) {
            return "null";
        }
        return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ValueDescriptorImpl parentDescriptor = (ValueDescriptorImpl)builder.getParentDescriptor();
        NodeManager nodeManager = builder.getNodeManager();
        NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
        ArrayList<DebuggerTreeNode> children = new ArrayList<DebuggerTreeNode>();
        if (value instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)value;
            ReferenceType refType = objRef.referenceType();
            List<Field> fields = refType.allFields();
            if (fields.size() > 0) {
                for (Field field : fields) {
                    if (!this.shouldDisplay(evaluationContext, objRef, field)) continue;
                    children.add(nodeManager.createNode(nodeDescriptorFactory.getFieldDescriptor(parentDescriptor, objRef, field), evaluationContext));
                }
                if (this.SORT_ASCENDING) {
                    Collections.sort(children, NodeManagerImpl.getNodeComparator());
                }
            } else {
                children.add(nodeManager.createMessageNode(MessageDescriptor.CLASS_HAS_NO_FIELDS.getLabel()));
            }
        }
        builder.setChildren(children);
    }

    private boolean shouldDisplay(EvaluationContext context, @NotNull ObjectReference objInstance, @NotNull Field field) {
        if (objInstance == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/ui/tree/render/ClassRenderer.shouldDisplay must not be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/ui/tree/render/ClassRenderer.shouldDisplay must not be null");
        }
        boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
        if (!this.SHOW_SYNTHETICS && isSynthetic) {
            return false;
        }
        if (isSynthetic && ((Object)objInstance).equals(context.getThisObject()) && StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) {
            return false;
        }
        if (!this.SHOW_STATIC && field.isStatic()) {
            return false;
        }
        return this.SHOW_STATIC_FINAL || !field.isStatic() || !field.isFinal();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Override
    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        FieldDescriptor fieldDescriptor = (FieldDescriptor)node.getDescriptor();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)node.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText(fieldDescriptor.getField().name(), (PsiElement)DebuggerUtils.findClass((String)fieldDescriptor.getObject().referenceType().name(), (Project)context.getProject(), (GlobalSearchScope)context.getDebugProcess().getSearchScope()));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{fieldDescriptor.getField().name()}), null);
        }
    }

    private static boolean valueExpandable(Value value) {
        try {
            if (value instanceof ArrayReference) {
                return ((ArrayReference)value).length() > 0;
            }
            if (value instanceof ObjectReference) {
                return ((ObjectReference)value).referenceType().allFields().size() > 0;
            }
        }
        catch (ObjectCollectedException e) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return ClassRenderer.valueExpandable(value);
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ReferenceType && !(type instanceof ArrayType);
    }

    @Override
    @NonNls
    public String getName() {
        return "Object";
    }

    @Override
    public void setName(String text) {
        LOG.assertTrue(false);
    }

    @Nullable
    public static String getEnumConstantName(ObjectReference objRef, ClassType classType) {
        do {
            if (!classType.isPrepared()) {
                return null;
            }
            if ((classType = classType.superclass()) != null) continue;
            return null;
        } while (!"java.lang.Enum".equals(classType.name()));
        Field field = classType.fieldByName("name");
        if (field == null) {
            return null;
        }
        Value value = objRef.getValue(field);
        if (!(value instanceof StringReference)) {
            return null;
        }
        return ((StringReference)value).value();
    }
}

