/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.ValueHint;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHintTreeComponent;

class ValueHintTreeComponent
extends AbstractValueHintTreeComponent<Pair<NodeDescriptorImpl, String>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHintTreeComponent");
    private final ValueHint myValueHint;
    private final InspectDebuggerTree myTree;

    public ValueHintTreeComponent(ValueHint valueHint, InspectDebuggerTree tree, String title) {
        super(valueHint, tree, Pair.create((Object)tree.getInspectDescriptor(), (Object)title));
        this.myValueHint = valueHint;
        this.myTree = tree;
    }

    @Override
    protected void updateTree(Pair<NodeDescriptorImpl, String> descriptorWithTitle) {
        final NodeDescriptorImpl descriptor = (NodeDescriptorImpl)descriptorWithTitle.first;
        final String title = (String)descriptorWithTitle.second;
        final DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(this.myValueHint.getProject()).getContext();
        context.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(context){

            @Override
            public void threadAction() {
                ValueHintTreeComponent.this.myTree.setInspectDescriptor(descriptor);
                ValueHintTreeComponent.this.myValueHint.showTreePopup(ValueHintTreeComponent.this.myTree, context, title, ValueHintTreeComponent.this);
            }
        });
    }

    @Override
    protected void setNodeAsRoot(Object node) {
        if (node instanceof DebuggerTreeNodeImpl) {
            this.myValueHint.shiftLocation();
            final DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
            final DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(this.myValueHint.getProject()).getContext();
            context.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(context){

                @Override
                public void threadAction() {
                    try {
                        NodeDescriptorImpl descriptor = debuggerTreeNode.getDescriptor();
                        TextWithImports evaluationText = DebuggerTreeNodeExpression.createEvaluationText(debuggerTreeNode, context);
                        String title = evaluationText.getText();
                        ValueHintTreeComponent.this.addToHistory(Pair.create((Object)descriptor, (Object)title));
                        ValueHintTreeComponent.this.myTree.setInspectDescriptor(descriptor);
                        ValueHintTreeComponent.this.myValueHint.showTreePopup(ValueHintTreeComponent.this.myTree, context, title, ValueHintTreeComponent.this);
                    }
                    catch (EvaluateException e1) {
                        LOG.debug((Throwable)e1);
                    }
                }
            });
        }
    }
}

