/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompoundPositionManager
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.CompoundPositionManager");
    private final ArrayList<PositionManager> myPositionManagers = new ArrayList();

    public CompoundPositionManager() {
    }

    public CompoundPositionManager(PositionManager manager) {
        this.appendPositionManager(manager);
    }

    public void appendPositionManager(PositionManager manager) {
        this.myPositionManagers.remove(manager);
        this.myPositionManagers.add(0, manager);
    }

    public SourcePosition getSourcePosition(Location location) {
        for (PositionManager positionManager : this.myPositionManagers) {
            try {
                return positionManager.getSourcePosition(location);
            }
            catch (NoDataException ignored) {
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<ReferenceType> getAllClasses(SourcePosition classPosition) {
        List list;
        for (PositionManager positionManager : this.myPositionManagers) {
            List list2;
            try {
                list2 = positionManager.getAllClasses(classPosition);
            }
            catch (NoDataException ignored) {
                continue;
            }
            list = list2;
            if (list2 == null) throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/CompoundPositionManager.getAllClasses must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/CompoundPositionManager.getAllClasses must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<Location> locationsOfLine(ReferenceType type, SourcePosition position) {
        List list;
        for (PositionManager positionManager : this.myPositionManagers) {
            List list2;
            try {
                list2 = positionManager.locationsOfLine(type, position);
            }
            catch (NoDataException ignored) {
                continue;
            }
            list = list2;
            if (list2 == null) throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/CompoundPositionManager.locationsOfLine must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/CompoundPositionManager.locationsOfLine must not return null");
    }

    public ClassPrepareRequest createPrepareRequest(ClassPrepareRequestor requestor, SourcePosition position) {
        for (PositionManager positionManager : this.myPositionManagers) {
            try {
                return positionManager.createPrepareRequest(requestor, position);
            }
            catch (NoDataException ignored) {
            }
        }
        return null;
    }
}

