/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.offlineViewer.OfflineRefElementNode;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import java.util.Comparator;

public class InspectionResultsViewComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        CommonProblemDescriptor descriptor;
        InspectionTreeNode node1 = (InspectionTreeNode)o1;
        InspectionTreeNode node2 = (InspectionTreeNode)o2;
        if (node1 instanceof InspectionSeverityGroupNode && node2 instanceof InspectionSeverityGroupNode) {
            InspectionSeverityGroupNode groupNode1 = (InspectionSeverityGroupNode)node1;
            InspectionSeverityGroupNode groupNode2 = (InspectionSeverityGroupNode)node2;
            return -SeverityRegistrar.getInstance(groupNode1.getProject()).compare(groupNode1.getSeverityLevel().getSeverity(), groupNode2.getSeverityLevel().getSeverity());
        }
        if (node1 instanceof InspectionGroupNode && node2 instanceof InspectionGroupNode) {
            return ((InspectionGroupNode)node1).getGroupTitle().compareToIgnoreCase(((InspectionGroupNode)node2).getGroupTitle());
        }
        if (node1 instanceof InspectionPackageNode && node2 instanceof InspectionPackageNode) {
            return ((InspectionPackageNode)node1).getPackageName().compareToIgnoreCase(((InspectionPackageNode)node2).getPackageName());
        }
        if (node1 instanceof InspectionNode && node2 instanceof InspectionNode) {
            return InspectionsConfigTreeComparator.getDisplayTextToSort(node1.toString()).compareToIgnoreCase(InspectionsConfigTreeComparator.getDisplayTextToSort(node2.toString()));
        }
        if (node1 instanceof InspectionNode) {
            return -1;
        }
        if (node2 instanceof InspectionNode) {
            return 1;
        }
        if (node1 instanceof OfflineRefElementNode && node2 instanceof OfflineRefElementNode || node1 instanceof OfflineProblemDescriptorNode && node2 instanceof OfflineProblemDescriptorNode) {
            Object userObject1 = node1.getUserObject();
            Object userObject2 = node2.getUserObject();
            if (userObject1 instanceof OfflineProblemDescriptor && userObject2 instanceof OfflineProblemDescriptor) {
                OfflineProblemDescriptor descriptor1 = (OfflineProblemDescriptor)userObject1;
                OfflineProblemDescriptor descriptor2 = (OfflineProblemDescriptor)userObject2;
                if (descriptor1.getLine() != descriptor2.getLine()) {
                    return descriptor1.getLine() - descriptor2.getLine();
                }
                return descriptor1.getFQName().compareTo(descriptor2.getFQName());
            }
            if (userObject1 instanceof OfflineProblemDescriptor) {
                return InspectionResultsViewComparator.compareLineNumbers(userObject2, (OfflineProblemDescriptor)userObject1);
            }
            if (userObject2 instanceof OfflineProblemDescriptor) {
                return -InspectionResultsViewComparator.compareLineNumbers(userObject1, (OfflineProblemDescriptor)userObject2);
            }
        }
        if (node1 instanceof RefElementNode && node2 instanceof RefElementNode) {
            return InspectionResultsViewComparator.compareEntities(((RefElementNode)node1).getElement(), ((RefElementNode)node2).getElement());
        }
        if (node1 instanceof ProblemDescriptionNode && node2 instanceof ProblemDescriptionNode) {
            CommonProblemDescriptor descriptor1 = ((ProblemDescriptionNode)node1).getDescriptor();
            CommonProblemDescriptor descriptor2 = ((ProblemDescriptionNode)node2).getDescriptor();
            if (descriptor1 instanceof ProblemDescriptor && descriptor2 instanceof ProblemDescriptor) {
                return ((ProblemDescriptor)descriptor1).getLineNumber() - ((ProblemDescriptor)descriptor2).getLineNumber();
            }
            if (descriptor1 != null && descriptor2 != null) {
                return descriptor1.getDescriptionTemplate().compareToIgnoreCase(descriptor2.getDescriptionTemplate());
            }
            return 0;
        }
        if (node1 instanceof RefElementNode && node2 instanceof ProblemDescriptionNode) {
            descriptor = ((ProblemDescriptionNode)node2).getDescriptor();
            if (descriptor instanceof ProblemDescriptor) {
                return InspectionResultsViewComparator.compareEntity(((RefElementNode)node1).getElement(), ((ProblemDescriptor)descriptor).getPsiElement());
            }
            return InspectionResultsViewComparator.compareEntities(((RefElementNode)node1).getElement(), ((ProblemDescriptionNode)node2).getElement());
        }
        if (node2 instanceof RefElementNode && node1 instanceof ProblemDescriptionNode) {
            descriptor = ((ProblemDescriptionNode)node1).getDescriptor();
            if (descriptor instanceof ProblemDescriptor) {
                return -InspectionResultsViewComparator.compareEntity(((RefElementNode)node2).getElement(), ((ProblemDescriptor)descriptor).getPsiElement());
            }
            return -InspectionResultsViewComparator.compareEntities(((RefElementNode)node2).getElement(), ((ProblemDescriptionNode)node1).getElement());
        }
        return 0;
    }

    private static int compareEntity(RefEntity entity, PsiElement element) {
        if (entity instanceof RefElement) {
            return PsiUtilBase.compareElementsByPosition((PsiElement)((RefElement)entity).getElement(), (PsiElement)element);
        }
        return -1;
    }

    private static int compareEntities(RefEntity entity1, RefEntity entity2) {
        if (entity1 instanceof RefElement && entity2 instanceof RefElement) {
            return PsiUtilBase.compareElementsByPosition((PsiElement)((RefElement)entity1).getElement(), (PsiElement)((RefElement)entity2).getElement());
        }
        if (entity1 != null && entity2 != null) {
            return entity1.getName().compareToIgnoreCase(entity2.getName());
        }
        return 0;
    }

    private static int compareLineNumbers(Object userObject, OfflineProblemDescriptor descriptor) {
        Document document;
        RefElement refElement;
        PsiElement psiElement;
        if (userObject instanceof RefElement && (psiElement = (refElement = (RefElement)userObject).getElement()) != null && (document = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiElement.getContainingFile())) != null) {
            return descriptor.getLine() - document.getLineNumber(psiElement.getTextOffset()) - 1;
        }
        return -1;
    }

    public static InspectionResultsViewComparator getInstance() {
        return InspectionResultsViewComparatorHolder.ourInstance;
    }

    private static class InspectionResultsViewComparatorHolder {
        private static final InspectionResultsViewComparator ourInstance = new InspectionResultsViewComparator();

        private InspectionResultsViewComparatorHolder() {
        }
    }
}

