/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.RefEntryPointFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.FilteringInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalJavaInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.util.RefFilter;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DummyEntryPointsTool
extends FilteringInspectionTool {
    private RefEntryPointFilter myFilter;
    private final UnusedDeclarationInspection myOwner;
    private QuickFixAction[] myQuickFixActions;

    public DummyEntryPointsTool(UnusedDeclarationInspection owner) {
        this.myOwner = owner;
    }

    @Override
    public RefFilter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = new RefEntryPointFilter();
        }
        return this.myFilter;
    }

    @Override
    public void runInspection(AnalysisScope scope, InspectionManager manager) {
    }

    @Override
    public void exportResults(Element parentNode) {
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors() {
        JobDescriptor[] jobDescriptorArray = new JobDescriptor[]{};
        if (jobDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/DummyEntryPointsTool.getJobDescriptors must not return null");
        }
        return jobDescriptorArray;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.dead.code.entry.points.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/DummyEntryPointsTool.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/DummyEntryPointsTool.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public String getShortName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/DummyEntryPointsTool.getShortName must not return null");
        }
        return "";
    }

    @Override
    public HTMLComposerImpl getComposer() {
        return new DeadHTMLComposer(this);
    }

    @Override
    public GlobalInspectionContextImpl getContext() {
        return this.myOwner.getContext();
    }

    @Override
    public QuickFixAction[] getQuickFixes(RefEntity[] refElements) {
        if (this.myQuickFixActions == null) {
            this.myQuickFixActions = new QuickFixAction[]{new MoveEntriesToSuspicious()};
        }
        return this.myQuickFixActions;
    }

    private class MoveEntriesToSuspicious
    extends QuickFixAction {
        private MoveEntriesToSuspicious() {
            super(InspectionsBundle.message((String)"inspection.dead.code.remove.from.entry.point.quickfix", (Object[])new Object[0]), null, null, DummyEntryPointsTool.this);
        }

        @Override
        protected boolean applyFix(RefElement[] refElements) {
            EntryPointsManager entryPointsManager = ((GlobalJavaInspectionContext)DummyEntryPointsTool.this.getContext().getExtension(GlobalJavaInspectionContextImpl.CONTEXT)).getEntryPointsManager(DummyEntryPointsTool.this.getContext().getRefManager());
            for (RefElement refElement : refElements) {
                entryPointsManager.removeEntryPoint(refElement);
            }
            return true;
        }
    }
}

