/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionDescriptionLinkHandler
extends TooltipLinkHandler {
    public void handleLink(@NotNull String descriptionSuffix, @NotNull Editor editor, @NotNull JEditorPane hintComponent) {
        if (descriptionSuffix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/InspectionDescriptionLinkHandler.handleLink must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/InspectionDescriptionLinkHandler.handleLink must not be null");
        }
        if (hintComponent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/hint/InspectionDescriptionLinkHandler.handleLink must not be null");
        }
        this.showDescription(descriptionSuffix, editor, hintComponent);
    }

    @Nullable
    public String getDescription(String shortName, Editor editor) {
        Project project = editor.getProject();
        assert (project != null);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        assert (file != null);
        InspectionProfileEntry tool = ((InspectionProfile)InspectionProfileManager.getInstance().getRootProfile()).getInspectionTool(shortName, (PsiElement)file);
        if (tool == null) {
            return null;
        }
        String description = tool.loadDescription();
        if (description == null) {
            description = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
        }
        return description;
    }

    private void showDescription(String shortName, final Editor editor, JEditorPane tooltip) {
        String description = this.getDescription(shortName, editor);
        if (description == null) {
            return;
        }
        JEditorPane pane = LineTooltipRenderer.initPane(description);
        pane.select(0, 0);
        pane.setPreferredSize(new Dimension(3 * tooltip.getPreferredSize().width / 2, 200));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)pane);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
        final JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)scrollPane).createPopup();
        pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JComponent contentComponent = editor.getContentComponent();
                MouseEvent newMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, contentComponent);
                popup.cancel();
                contentComponent.dispatchEvent(newMouseEvent);
            }
        });
        popup.showUnderneathOf((Component)tooltip);
    }
}

